/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.fujion.common.StrUtil;

public class Version
implements Comparable<Version> {
    private final int[] seq = new int[4];

    public Version() {
    }

    public Version(String value) {
        if (value != null && !value.isEmpty()) {
            String[] pcs = StrUtil.split(value, ".", 4);
            for (int i = 0; i < 4; ++i) {
                this.seq[i] = StrUtil.extractInt(pcs[i]);
            }
        }
    }

    public Version(int major) {
        this(major, 0, 0, 0);
    }

    public Version(int major, int minor) {
        this(major, minor, 0, 0);
    }

    public Version(int major, int minor, int release) {
        this(major, minor, release, 0);
    }

    public Version(int major, int minor, int release, int build) {
        this.seq[VersionPart.MAJOR.ordinal()] = major;
        this.seq[VersionPart.MINOR.ordinal()] = minor;
        this.seq[VersionPart.RELEASE.ordinal()] = release;
        this.seq[VersionPart.BUILD.ordinal()] = build;
    }

    public boolean equals(Object v) {
        return v instanceof Version && this.compareTo((Version)v) == 0;
    }

    @Override
    public int compareTo(Version v) {
        int diff = 0;
        for (int i = 0; i < 4 && (diff = this.seq[i] - v.seq[i]) == 0; ++i) {
        }
        return diff;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.seq).hashCode();
    }

    public String toString(VersionPart part) {
        StringBuilder sb = new StringBuilder();
        int pad = part == null ? -1 : part.ordinal();
        String dot = "";
        for (int i = 3; i >= 0; --i) {
            int j = this.seq[i];
            if (j != 0) {
                pad = i;
            } else if (i > pad) continue;
            sb.insert(0, dot).insert(0, j);
            dot = ".";
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public static enum VersionPart {
        MAJOR,
        MINOR,
        RELEASE,
        BUILD;

    }
}

