/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Collection;
import java.util.Iterator;

public class ProxiedCollection<T>
implements Collection<T> {
    protected final Collection<T> delegate;
    private final IProxiedCollectionOperations<T> operations;

    public ProxiedCollection(Collection<T> delegate, IProxiedCollectionOperations<T> operations) {
        this.delegate = delegate;
        this.operations = operations;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> iterator = this.delegate.iterator();
        return new Iterator<T>(){
            private T current;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                this.current = iterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                ProxiedCollection.this.operations.remove(this.current, iterator);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public final boolean add(T element) {
        return this.operations.add(element, this.delegate);
    }

    @Override
    public final boolean remove(Object element) {
        return this.operations.remove(element, this.delegate);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T element : c) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object element : c) {
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            T element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public final void clear() {
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public static interface IProxiedCollectionOperations<T> {
        public boolean add(T var1, Collection<T> var2);

        public boolean remove(Object var1, Collection<T> var2);

        default public void remove(T element, Iterator<T> iterator) {
            throw new UnsupportedOperationException();
        }
    }
}

