/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.fujion.common.Localizer;

public class StrUtil {
    public static final String CRLF = "\r\n";
    public static final String CRLF2 = "\r\n\r\n";
    public static final String LINE_TERMINATOR = "\n";
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    public static final String UTF8_STR = "UTF-8";

    public static String[] split(String text, String delimiter) {
        return StrUtil.split(text, delimiter, 0);
    }

    public static String[] split(String text, String delimiter, int count) {
        return StrUtil.split(text, delimiter, count, true);
    }

    public static String[] split(String text, String delimiter, int count, boolean nonull) {
        String[] pcs = text == null ? new String[count] : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)delimiter);
        String[] stringArray = pcs = pcs.length >= count ? pcs : Arrays.copyOf(pcs, count);
        if (nonull) {
            for (int i = 0; i < pcs.length; ++i) {
                if (pcs[i] != null) continue;
                pcs[i] = "";
            }
        }
        return pcs;
    }

    public static String strTruncate(String value, int maxLength) {
        return value == null ? null : (value.length() <= maxLength ? value : value.substring(0, maxLength) + "...");
    }

    public static StringBuilder strAppend(StringBuilder sb, String value) {
        return StrUtil.strAppend(sb, value, ", ");
    }

    public static StringBuilder strAppend(StringBuilder sb, String value, String separator) {
        if (value != null && !value.isEmpty()) {
            sb.append(sb.length() == 0 ? "" : separator).append(value);
        }
        return sb;
    }

    public static String strAppend(String text, String value) {
        return StrUtil.strAppend(text, value, ", ");
    }

    public static String strAppend(String text, String value, String separator) {
        if (text == null) {
            text = "";
        }
        if (value == null || value.isEmpty()) {
            return text;
        }
        return text + (text.isEmpty() ? "" : separator) + value;
    }

    public static String toDelimitedStr(String delimiter, Object ... params) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (params != null) {
            for (Object param : params) {
                if (!first) {
                    sb.append(delimiter);
                } else {
                    first = false;
                }
                if (param == null) continue;
                sb.append(param);
            }
        }
        return sb.toString();
    }

    public static String piece(String text, String delimiter) {
        return StrUtil.piece(text, delimiter, 1);
    }

    public static String piece(String text, String delimiter, int position) {
        return StrUtil.piece(text, delimiter, position, position);
    }

    public static String piece(String text, String delimiter, int start, int end) {
        String[] pcs = StrUtil.split(text, delimiter);
        StringBuilder result = new StringBuilder(text.length());
        if (start < 1) {
            start = 1;
        }
        if (start > pcs.length || start > end) {
            return "";
        }
        end = (end <= pcs.length ? end : pcs.length) - 1;
        for (int i = --start; i <= end; ++i) {
            result.append(pcs[i]);
            if (i >= end) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static int extractInt(String value) {
        return StrUtil.toInt(StrUtil.extractIntPrefix(value));
    }

    public static String extractIntPrefix(String value) {
        int pos = 0;
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        if (value.startsWith("+") || value.startsWith("-")) {
            ++pos;
        }
        while (pos < value.length() && Character.isDigit(value.charAt(pos))) {
            ++pos;
        }
        return value.substring(0, pos);
    }

    public static String stripQuotes(String value) {
        String qt;
        String string = value == null ? null : (value.startsWith("\"") ? "\"" : (qt = value.startsWith("'") ? "'" : null));
        if (qt != null && value.endsWith(qt)) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static boolean toBoolean(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return false;
        }
        String char1 = text.substring(0, 1).toLowerCase();
        return "y".equals(char1) || "t".equals(char1) || NumberUtils.toInt((String)text) != 0;
    }

    public static int toInt(String text) {
        return NumberUtils.toInt((String)text);
    }

    public static long toLong(String text) {
        return NumberUtils.toLong((String)text);
    }

    public static double toDouble(String text) {
        return NumberUtils.toDouble((String)text);
    }

    public static List<String> toList(String text) {
        return StrUtil.toList(text, null, LINE_TERMINATOR);
    }

    public static List<String> toList(String text, String delimiter) {
        return StrUtil.toList(text, null, delimiter);
    }

    public static List<String> toList(String text, List<String> list) {
        return StrUtil.toList(text, list, LINE_TERMINATOR);
    }

    public static List<String> toList(String text, List<String> list, String delimiter) {
        int size;
        String[] pcs;
        if (list == null) {
            list = new ArrayList<String>();
        } else {
            list.clear();
        }
        if (text == null) {
            return list;
        }
        if (delimiter == null || delimiter.isEmpty()) {
            pcs = new String[]{text};
            size = 1;
        } else {
            pcs = StrUtil.split(text, delimiter);
            size = text.endsWith(delimiter) ? pcs.length - 1 : pcs.length;
        }
        for (int i = 0; i < size; ++i) {
            list.add(pcs[i]);
        }
        return list;
    }

    public static String fromList(Iterable<?> list) {
        return StrUtil.fromList(list, LINE_TERMINATOR);
    }

    public static String fromList(Iterable<?> list, String delimiter) {
        return StrUtil.fromList(list, delimiter, "");
    }

    public static String fromList(Iterable<?> list, String delimiter, String dflt) {
        StringBuilder sb = new StringBuilder();
        boolean addDelimiter = false;
        for (Object ln : list) {
            ln = ln == null ? dflt : ln;
            if (ln == null) continue;
            if (addDelimiter) {
                sb.append(delimiter);
            } else {
                addDelimiter = true;
            }
            sb.append(ln);
        }
        return sb.toString();
    }

    public static String toCamelCaseUpper(String text) {
        return text == null ? null : WordUtils.capitalizeFully((String)StringUtils.normalizeSpace((String)text.replace('_', ' '))).replace(" ", "");
    }

    public static String toCamelCaseLower(String text) {
        return StringUtils.uncapitalize((String)StrUtil.toCamelCaseUpper(text));
    }

    public static String xlate(String text, String from, String to) {
        return StringUtils.replaceChars((String)text, (String)from, (String)to);
    }

    public static String formatMessage(String msg, Locale locale, Object ... args) {
        String message;
        if (msg == null || msg.isEmpty()) {
            return msg;
        }
        String string = message = msg.startsWith("@") ? StrUtil.getLabel(msg, locale, args) : null;
        if (message == null && args != null && args.length > 0) {
            message = String.format(locale == null ? Localizer.getDefaultLocale() : locale, msg, args);
        }
        return message == null ? msg : message;
    }

    public static String formatMessage(String msg, Object ... args) {
        return StrUtil.formatMessage(msg, null, args);
    }

    public static String getLabel(String id, Object ... args) {
        return StrUtil.getLabel(id, null, args);
    }

    public static String getLabel(String id, Locale locale, Object ... args) {
        if (id.startsWith("@")) {
            id = id.substring(1);
        }
        return Localizer.getMessage(id, locale, args);
    }

    private StrUtil() {
    }
}

