/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Date;
import org.fujion.common.DateUtil;
import org.fujion.common.StrUtil;

public class DateRange {
    private static final String DELIM = "|";
    private static final String REGEX_DELIM = "\\|";
    private String label = "";
    private String rawStartDate;
    private String rawEndDate;
    private Date startDate;
    private Date endDate;
    private boolean dflt;

    public DateRange(String data) {
        String[] pcs = data.split(REGEX_DELIM);
        this.label = pcs[0];
        this.setStartDate(this.fromArray(pcs, 1));
        this.setEndDate(this.fromArray(pcs, 2));
        this.setDefault(this.fromArray(pcs, 3));
        this.checkDates();
    }

    public DateRange(String label, Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.rawStartDate = DateUtil.formatDate(startDate);
        this.rawEndDate = DateUtil.formatDate(endDate);
        this.checkDates();
        this.label = label != null ? label : this.rawStartDate + " to " + this.rawEndDate;
    }

    public DateRange(Date startDate, Date endDate) {
        this(null, startDate, endDate);
    }

    public DateRange(DateRange dateRange) {
        this.dflt = dateRange.dflt;
        this.label = dateRange.label;
        this.endDate = DateUtil.cloneDate(dateRange.endDate);
        this.rawEndDate = dateRange.rawEndDate;
        this.startDate = DateUtil.cloneDate(dateRange.startDate);
        this.rawStartDate = dateRange.rawStartDate;
    }

    public boolean equals(Object value) {
        if (!(value instanceof DateRange)) {
            return false;
        }
        if (value == this) {
            return true;
        }
        DateRange range = (DateRange)value;
        if (range.startDate == this.startDate && range.endDate == this.endDate) {
            return true;
        }
        if (range.startDate == null || range.endDate == null) {
            return false;
        }
        return range.startDate.equals(this.startDate) && range.endDate.equals(this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.addComponent(sb, this.label);
        this.addComponent(sb, this.rawStartDate);
        this.addComponent(sb, this.rawEndDate);
        sb.append(this.dflt ? "1" : "");
        return sb.toString();
    }

    private void addComponent(StringBuilder sb, String comp) {
        sb.append(comp == null ? "" : comp);
        sb.append(DELIM);
    }

    private void checkDates() {
        if (this.startDate == null || this.endDate == null) {
            return;
        }
        if (this.startDate.after(this.endDate)) {
            Date date = this.startDate;
            String rawDate = this.rawStartDate;
            this.startDate = this.endDate;
            this.rawStartDate = this.rawEndDate;
            this.endDate = date;
            this.rawEndDate = rawDate;
        }
    }

    private String fromArray(String[] array, int index) {
        return index >= array.length || index < 0 ? "" : array[index];
    }

    private void setStartDate(String startDate) {
        this.rawStartDate = startDate;
        this.startDate = DateUtil.parseDate(startDate);
    }

    private void setEndDate(String endDate) {
        this.rawEndDate = endDate;
        this.endDate = DateUtil.parseDate(endDate);
    }

    private void setDefault(String value) {
        this.dflt = StrUtil.toBoolean(value);
    }

    public String getLabel() {
        return this.label;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getRawStartDate() {
        return this.rawStartDate;
    }

    public String getRawEndDate() {
        return this.rawEndDate;
    }

    public boolean isDefault() {
        return this.dflt;
    }

    public boolean inRange(Date refDate) {
        return this.inRange(refDate, true, false);
    }

    public boolean inRange(Date refDate, boolean inclusiveStart, boolean inclusiveEnd) {
        int cmp;
        if (refDate == null) {
            return false;
        }
        int n = cmp = this.startDate == null ? 1 : refDate.compareTo(this.startDate);
        if (cmp < 0 || !inclusiveStart && cmp == 0) {
            return false;
        }
        int n2 = cmp = this.endDate == null ? -1 : refDate.compareTo(this.endDate);
        return cmp <= 0 && (inclusiveEnd || cmp != 0);
    }

    public boolean inRange(DateRange refRange) {
        return this.inRange(refRange, true, false);
    }

    public boolean inRange(DateRange refRange, boolean inclusiveStart, boolean inclusiveEnd) {
        return this.inRange(refRange.startDate, inclusiveStart, inclusiveEnd) && this.inRange(refRange.endDate, inclusiveStart, inclusiveEnd);
    }
}

