/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Collection;
import java.util.Iterator;
import org.fujion.common.ProxiedCollection;

public class ObservedCollection<T>
extends ProxiedCollection<T> {
    public ObservedCollection(Collection<T> delegate, final IObservedCollectionListener<T> listener) {
        super(delegate, new ProxiedCollection.IProxiedCollectionOperations<T>(){

            @Override
            public boolean add(T element, Collection<T> delegate) {
                if (delegate.add(element)) {
                    listener.onAddElement(element);
                    return true;
                }
                return false;
            }

            @Override
            public boolean remove(Object element, Collection<T> delegate) {
                if (delegate.remove(element)) {
                    listener.onRemoveElement(element);
                    return true;
                }
                return false;
            }

            @Override
            public void remove(T element, Iterator<T> iterator) {
                iterator.remove();
                listener.onRemoveElement(element);
            }
        });
    }

    public static interface IObservedCollectionListener<T> {
        public void onAddElement(T var1);

        public void onRemoveElement(T var1);
    }
}

