/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RegistryMap<KEY, VALUE>
implements Map<KEY, VALUE> {
    private final Map<KEY, VALUE> map;
    private final DuplicateAction duplicateAction;

    public RegistryMap() {
        this(null, null);
    }

    public RegistryMap(Map<KEY, VALUE> map) {
        this(map, null);
    }

    public RegistryMap(DuplicateAction duplicateAction) {
        this(null, duplicateAction);
    }

    public RegistryMap(Map<KEY, VALUE> map, DuplicateAction duplicateAction) {
        this.duplicateAction = duplicateAction == null ? DuplicateAction.REPLACE : duplicateAction;
        this.map = map == null ? new ConcurrentHashMap() : map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public VALUE get(Object key) {
        return this.map.get(key);
    }

    @Override
    public VALUE put(KEY key, VALUE value) {
        Object oldValue = null;
        if (key != null) {
            oldValue = this.map.get(key);
            if (value == null) {
                this.map.remove(key);
                return (VALUE)oldValue;
            }
            if (oldValue == null) {
                this.map.put(key, value);
            } else {
                switch (this.duplicateAction) {
                    case IGNORE: {
                        break;
                    }
                    case REPLACE: {
                        this.map.put(key, value);
                        break;
                    }
                    case ERROR: {
                        if (oldValue.equals(value)) break;
                        throw new IllegalArgumentException("Cannot modify existing entry with the key '" + key + "'.");
                    }
                }
            }
        }
        return (VALUE)oldValue;
    }

    @Override
    public VALUE remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends VALUE> m) {
        for (Map.Entry<KEY, VALUE> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<KEY> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<VALUE> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<KEY, VALUE>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public static enum DuplicateAction {
        REPLACE,
        IGNORE,
        ERROR;

    }
}

