/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtil {
    private static final DocumentBuilderFactory nsUnawareFactory = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilderFactory nsAwareFactory = DocumentBuilderFactory.newInstance();

    private static void initFactory(DocumentBuilderFactory factory, boolean nsAware) {
        try {
            factory.setNamespaceAware(nsAware);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public static DocumentBuilder newDocumentBuilder(boolean nsAware) throws ParserConfigurationException {
        return (nsAware ? nsAwareFactory : nsUnawareFactory).newDocumentBuilder();
    }

    public static Document parseXMLFromSource(InputSource source) throws Exception {
        return XMLUtil.newDocumentBuilder(false).parse(source);
    }

    public static Document parseXMLFromString(String xml) throws Exception {
        return XMLUtil.parseXMLFromStream(IOUtils.toInputStream((String)xml, (Charset)StandardCharsets.UTF_8));
    }

    public static Document parseXMLFromList(Iterable<String> xml) throws Exception {
        return XMLUtil.parseXMLFromString(StrUtil.fromList(xml));
    }

    public static Document parseXMLFromLocation(String filePath) throws Exception {
        return XMLUtil.parseXMLFromStream(new FileInputStream(filePath));
    }

    public static Document parseXMLFromStream(InputStream stream) throws Exception {
        Document document = XMLUtil.newDocumentBuilder(false).parse(stream);
        stream.close();
        return document;
    }

    public static String toString(Document doc) {
        return XMLUtil.toString(doc, 4);
    }

    public static String toString(Document doc, int indent) {
        if (doc == null) {
            return "";
        }
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", indent);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", indent > 0 ? "yes" : "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked(e);
        }
    }

    public static String formatNodeName(Node node, TagFormat format) {
        StringBuilder sb = new StringBuilder((format == TagFormat.CLOSING ? "</" : "<") + node.getNodeName());
        if (format != TagFormat.CLOSING) {
            sb.append(XMLUtil.formatAttributes(node));
        }
        sb.append(format == TagFormat.EMPTY ? " />" : ">");
        if (format == TagFormat.BOTH) {
            sb.append(XMLUtil.formatNodeName(node, TagFormat.CLOSING));
        }
        return sb.toString();
    }

    public static String formatAttributes(Node node) {
        StringBuilder sb = new StringBuilder();
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            sb.append(' ').append(attr.getNodeName()).append("= '").append(attr.getNodeValue()).append("'");
        }
        return sb.toString();
    }

    private XMLUtil() {
    }

    static {
        XMLUtil.initFactory(nsUnawareFactory, false);
        XMLUtil.initFactory(nsAwareFactory, true);
    }

    public static enum TagFormat {
        OPENING,
        CLOSING,
        BOTH,
        EMPTY;

    }
}

