/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class CyclicIterator<T>
implements Iterator<T> {
    private final Collection<T> collection;
    private Iterator<T> iterator;
    private final boolean hasNext;

    public CyclicIterator(Collection<T> collection) {
        this.collection = collection;
        this.hasNext = collection != null && !collection.isEmpty();
    }

    public CyclicIterator(T[] array) {
        this.collection = array == null ? null : Arrays.asList(array);
        this.hasNext = this.collection != null && !this.collection.isEmpty();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        this.iterator = this.iterator == null || !this.iterator.hasNext() ? this.collection.iterator() : this.iterator;
        return this.iterator.next();
    }

    public void reset() {
        this.iterator = null;
    }
}

