/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.fujion.common.WeakCollectionBase;

public class WeakList<E>
extends WeakCollectionBase<E>
implements List<E> {
    private final List<WeakReference<E>> referenceList = new ArrayList<WeakReference<E>>();

    public WeakList() {
    }

    public WeakList(WeakList<E> source) {
        for (E element : source) {
            if (element == null) continue;
            this.add(element);
        }
    }

    @Override
    public E set(int index, E element) {
        E previous = this.get(index);
        this.referenceList.set(index, this.createWeakReference(element));
        return previous;
    }

    @Override
    public E remove(int index) {
        return this.getReferent(this.referenceList.remove(index));
    }

    @Override
    public void add(int index, E element) {
        this.referenceList.add(index, this.createWeakReference(element));
    }

    @Override
    public E get(int index) {
        return this.getReferent(this.referenceList.get(index));
    }

    @Override
    public int size() {
        this.compact();
        return this.referenceList.size();
    }

    @Override
    public boolean isEmpty() {
        this.compact();
        return this.referenceList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.contains(this.referenceList, o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getIterator(this.referenceList);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.compact();
        T[] ary = this.referenceList.toArray(a);
        for (int i = 0; i < ary.length; ++i) {
            ary[i] = this.getReferent((WeakReference)ary[i]);
        }
        return ary;
    }

    @Override
    public boolean add(E e) {
        return this.referenceList.add(this.createWeakReference(e));
    }

    @Override
    public boolean remove(Object o) {
        Object element = this.cast(o);
        return element != null && this.referenceList.remove(this.createWeakReference(element));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (E element : c) {
            result |= this.add(element);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = false;
        for (E element : c) {
            this.add(index++, element);
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object element : c) {
            result |= this.remove(element);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.referenceList.clear();
    }

    @Override
    public int indexOf(Object o) {
        Object element = this.cast(o);
        return element == null ? -1 : this.referenceList.indexOf(this.createWeakReference(element));
    }

    @Override
    public int lastIndexOf(Object o) {
        Object element = this.cast(o);
        return element == null ? -1 : this.referenceList.lastIndexOf(this.createWeakReference(element));
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeReference(Reference<? extends E> reference) {
        this.referenceList.remove(reference);
    }
}

