/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.fujion.common.BundleMessageSource;
import org.fujion.common.ColorUtil;
import org.fujion.common.CyclicIterator;
import org.fujion.common.DateRange;
import org.fujion.common.DateUtil;
import org.fujion.common.JSONUtil;
import org.fujion.common.Localizer;
import org.fujion.common.MiscUtil;
import org.fujion.common.NumUtil;
import org.fujion.common.ObservedCollection;
import org.fujion.common.QueryStringBuilder;
import org.fujion.common.StrUtil;
import org.fujion.common.TestPerson;
import org.fujion.common.Version;
import org.fujion.common.WeakList;
import org.fujion.common.WeakMap;
import org.junit.Assert;
import org.junit.Test;

public class CommonTest {
    private static final String DATE = "21-Nov-1978";
    private static final String QT_NONE = "This is a test.";
    private static final String QT_DOUBLE = "\"This is a test.\"";
    private static final String QT_SINGLE = "'This is a test.'";
    private static final String QT_OTHER1 = "\"This is a test.'";
    private static final String QT_OTHER2 = "\"This is a test.";
    private static final String QT_OTHER3 = "This is a test.'";
    private static final String CAMEL_UCASE_RESULT = "TestOfCamelCase";
    private static final String CAMEL_LCASE_RESULT = "testOfCamelCase";
    private static final Integer[] CYCLIC_COLLECTION = new Integer[]{0, 1, 2};

    @Test
    public void testPiece() {
        String text = "pc1^pc2^pc3^^pc5^pc6^^^";
        String delm = "^";
        Assert.assertEquals((Object)"pc1", (Object)StrUtil.piece((String)text, (String)delm));
        Assert.assertEquals((Object)"pc2", (Object)StrUtil.piece((String)text, (String)delm, (int)2));
        Assert.assertEquals((Object)"pc3^^pc5", (Object)StrUtil.piece((String)text, (String)delm, (int)3, (int)5));
        Assert.assertEquals((Object)"pc6^^^", (Object)StrUtil.piece((String)text, (String)delm, (int)6, (int)9999));
        Assert.assertEquals((Object)"", (Object)StrUtil.piece((String)text, (String)delm, (int)0));
        Assert.assertEquals((Object)"", (Object)StrUtil.piece((String)text, (String)delm, (int)0, (int)0));
        Assert.assertEquals((Object)"pc1^pc2^pc3^^pc5", (Object)StrUtil.piece((String)text, (String)delm, (int)0, (int)5));
    }

    @Test
    public void testNumUtil() {
        Assert.assertEquals((Object)"0", (Object)NumUtil.toString((double)0.0));
        Assert.assertEquals((Object)"1.25", (Object)NumUtil.toString((double)1.25));
        Assert.assertEquals((Object)"125", (Object)NumUtil.toString((double)125.0));
        Assert.assertTrue((NumUtil.compare((int)1, (int)2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumUtil.compare((int)5, (int)5) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumUtil.compare((int)6, (int)3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumUtil.compare((double)1.34, (double)2.5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumUtil.compare((double)3.54, (double)3.54) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((NumUtil.compare((double)5.45, (double)5.31) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)NumUtil.enforceRange((int)10, (int)1, (int)5));
        Assert.assertEquals((long)10L, (long)NumUtil.enforceRange((int)10, (int)1, (int)20));
        Assert.assertEquals((long)5L, (long)NumUtil.enforceRange((int)1, (int)5, (int)20));
    }

    @Test
    public void testBooleanUtil() {
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"YES"));
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"Y"));
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"yes"));
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"y"));
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"TRUE"));
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"t"));
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"1"));
        Assert.assertTrue((boolean)StrUtil.toBoolean((String)"100"));
        Assert.assertFalse((boolean)StrUtil.toBoolean(null));
        Assert.assertFalse((boolean)StrUtil.toBoolean((String)""));
        Assert.assertFalse((boolean)StrUtil.toBoolean((String)"false"));
        Assert.assertFalse((boolean)StrUtil.toBoolean((String)"0"));
        Assert.assertFalse((boolean)StrUtil.toBoolean((String)"any old string"));
    }

    @Test
    public void testDateUtil() {
        this.testDate(this.now());
        this.testDate(this.today());
        this.testDate("T", this.today(), 0);
        this.testDate("N", this.now(), 100);
        this.testDate("T+30", DateUtil.addDays((Date)this.today(), (int)30, (boolean)false), 0);
        this.testDate("N+30", DateUtil.addDays((Date)this.now(), (int)30, (boolean)false), 100);
        this.testDate("T-4", DateUtil.addDays((Date)this.today(), (int)-4, (boolean)false), 0);
        this.testDate("T-50s", new Date(this.today().getTime() - 50000L), 0);
        this.testDate("N-50s", new Date(this.now().getTime() - 50000L), 100);
        this.testDate("T-50h", new Date(this.today().getTime() - 180000000L), 0);
        this.testDate("T-50n", new Date(this.today().getTime() - 3000000L), 0);
        Date date = DateUtil.parseDate((String)"19880302");
        this.testDate(date.toString(), date, 0);
    }

    private Date now() {
        return new Date();
    }

    private Date today() {
        return DateUtil.stripTime((Date)this.now());
    }

    private void testDate(String value, Date expected, int threshold) {
        Date actual = DateUtil.parseDate((String)value);
        this.testDate(actual);
        long diff = Math.abs(expected.getTime() - actual.getTime());
        Assert.assertTrue((String)("Difference exceeded threshold " + diff + " (" + threshold + ")"), (diff <= (long)threshold ? 1 : 0) != 0);
    }

    private void testDate(Date date) {
        this.testDate(date, true, true);
        this.testDate(date, false, false);
        this.testDate(date, true, false);
        this.testDate(date, false, true);
    }

    private void testDate(Date date, boolean showTimezone, boolean ignoreTime) {
        String text = DateUtil.formatDate((Date)date, (boolean)showTimezone, (boolean)ignoreTime);
        this.print(text);
        Date date2 = DateUtil.parseDate((String)text);
        String text2 = DateUtil.formatDate((Date)date2, (boolean)showTimezone, (boolean)ignoreTime);
        Assert.assertEquals((Object)text, (Object)text2);
    }

    @Test
    public void testDefaultTimeZone() throws Exception {
        this.testDateFormat("EST", "13:04");
        this.testDateFormat("GMT", "18:04");
        this.testDateFormat("CST", "12:04");
    }

    @Test
    public void testFormatting() throws Exception {
        this.doTestFormatting("", "");
        this.doTestFormatting(" 00:00", "");
        this.doTestFormatting(" 13:24", " 13:24");
        this.doTestFormatting(" 00:39", " 00:39");
    }

    private void doTestFormatting(String time, String expected) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy" + (time.length() == 0 ? "" : " HH:mm"));
        Date date = formatter.parse(DATE + time);
        Assert.assertEquals((Object)DateUtil.formatDate((Date)date), (Object)(DATE + expected));
    }

    private void testDateFormat(String tz, String time) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm zzz");
        Date date = formatter.parse("21-Nov-1978 13:04 EST");
        TimeZone.setDefault(TimeZone.getTimeZone(tz));
        String DATE_TIME_NOTZ = "21-Nov-1978 " + time;
        String DATE_TIME_TZ = DATE_TIME_NOTZ + " " + tz;
        Assert.assertEquals((Object)DATE_TIME_TZ, (Object)DateUtil.formatDate((Date)date, (boolean)true));
        Assert.assertEquals((Object)DATE_TIME_NOTZ, (Object)DateUtil.formatDate((Date)date));
        Assert.assertEquals((Object)DATE, (Object)DateUtil.formatDate((Date)date, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)DATE_TIME_NOTZ, (Object)DateUtil.formatDate((Date)date, (boolean)false));
        Assert.assertEquals((Object)DATE_TIME_NOTZ, (Object)DateUtil.formatDate((Date)date, (boolean)false, (boolean)false));
        formatter = new SimpleDateFormat("dd-MMM-yyyy");
        date = formatter.parse(DATE);
        Assert.assertEquals((Object)DATE, (Object)DateUtil.formatDate((Date)date, (boolean)true));
        Assert.assertEquals((Object)DATE, (Object)DateUtil.formatDate((Date)date));
        Assert.assertEquals((Object)DATE, (Object)DateUtil.formatDate((Date)date, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)DATE, (Object)DateUtil.formatDate((Date)date, (boolean)false));
        Assert.assertEquals((Object)DATE, (Object)DateUtil.formatDate((Date)date, (boolean)false, (boolean)false));
    }

    @Test
    public void testDateRange() {
        DateRange dr = new DateRange("test|12-Jul-2010|15-Aug-2010");
        Assert.assertEquals((Object)dr.getStartDate(), (Object)DateUtil.toDate((int)12, (int)7, (int)2010));
        Assert.assertEquals((Object)dr.getEndDate(), (Object)DateUtil.toDate((int)15, (int)8, (int)2010));
        Assert.assertTrue((boolean)dr.inRange(DateUtil.toDate((int)1, (int)8, (int)2010)));
        Assert.assertFalse((boolean)dr.inRange(DateUtil.toDate((int)15, (int)8, (int)2010)));
        Assert.assertTrue((boolean)dr.inRange(DateUtil.toDate((int)15, (int)8, (int)2010), true, true));
        Assert.assertFalse((boolean)dr.inRange(DateUtil.toDate((int)15, (int)8, (int)2010, (int)13, (int)30, (int)0), true, true));
        Assert.assertFalse((boolean)dr.inRange(DateUtil.toDate((int)16, (int)8, (int)2010), true, true));
    }

    @Test
    public void testSerializer() {
        JSONUtil.registerAlias((String)"TestPerson", TestPerson.class);
        this.testSerializer(null);
        this.testSerializer("resourceType");
    }

    private void testSerializer(String typeProperty) {
        TestPerson obj = new TestPerson();
        String s = JSONUtil.serialize((String)typeProperty, (Object)obj);
        this.print(s);
        TestPerson obj2 = (TestPerson)JSONUtil.deserialize((String)typeProperty, (String)s);
        Assert.assertTrue((boolean)obj.equals(obj2));
        ArrayList<TestPerson> list = new ArrayList<TestPerson>();
        list.add(obj);
        list.add(obj);
        s = JSONUtil.serialize((String)typeProperty, list);
        this.print(s);
        List list2 = JSONUtil.deserializeList((String)typeProperty, (String)s, TestPerson.class);
        Assert.assertEquals(list, (Object)list2);
        List list3 = (List)JSONUtil.deserialize((String)typeProperty, (String)s);
        Assert.assertEquals(list, (Object)list3);
    }

    @Test
    public void testElapsed() {
        Assert.assertEquals((Object)"0.1 seconds", (Object)DateUtil.formatElapsed((double)100.0, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS));
        Assert.assertEquals((Object)"1 second", (Object)DateUtil.formatElapsed((double)1000.0));
        Assert.assertEquals((Object)"1 minute", (Object)DateUtil.formatElapsed((double)60000.0));
        Assert.assertEquals((Object)"3.59 days", (Object)DateUtil.formatElapsed((double)3.09898934E8));
        Assert.assertEquals((Object)"98.2 years", (Object)DateUtil.formatElapsed((double)3.098989343984E12));
        Assert.assertEquals((Object)"-98.2 years", (Object)DateUtil.formatElapsed((double)-3.098989343984E12));
        Assert.assertEquals((double)100.0, (double)DateUtil.parseElapsed((String)"0.1 seconds"), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)DateUtil.parseElapsed((String)"1 second"), (double)0.0);
        Assert.assertEquals((double)60000.0, (double)DateUtil.parseElapsed((String)"1 minute"), (double)0.0);
        Assert.assertEquals((double)3.10176E8, (double)DateUtil.parseElapsed((String)"3.59 days"), (double)0.0);
        Assert.assertEquals((double)3.09895632E12, (double)DateUtil.parseElapsed((String)"98.2 years"), (double)0.0);
        Assert.assertEquals((double)-3.09895632E12, (double)DateUtil.parseElapsed((String)"-98.2 years"), (double)0.0);
        Assert.assertEquals((double)98.2, (double)DateUtil.parseElapsed((String)"98.2 years", (DateUtil.TimeUnit)DateUtil.TimeUnit.YEARS), (double)0.0);
    }

    @Test
    public void testDuration() {
        Assert.assertEquals((Object)"0 seconds", (Object)DateUtil.formatDuration((long)100L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS));
        Assert.assertEquals((Object)"0 sec", (Object)DateUtil.formatDuration((long)100L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS, (boolean)false, (boolean)true));
        Assert.assertEquals((Object)"1 second", (Object)DateUtil.formatDuration((long)1000L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS));
        Assert.assertEquals((Object)"1 minute", (Object)DateUtil.formatDuration((long)60000L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS));
        Assert.assertEquals((Object)"3 days 14 hours 4 minutes 58 seconds", (Object)DateUtil.formatDuration((long)309898934L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS));
        Assert.assertEquals((Object)"3 day 14 hour 4 minute 58 second", (Object)DateUtil.formatDuration((long)309898934L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)"98 years 2 months 1 week 6 days 10 hours 22 minutes 23 seconds", (Object)DateUtil.formatDuration((long)3098989343984L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS));
        Assert.assertEquals((Object)"3 days 14 hrs 4 mins 58 secs", (Object)DateUtil.formatDuration((long)309898934L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)"-98 years 2 months 1 week 6 days 10 hours 22 minutes 23 seconds", (Object)DateUtil.formatDuration((long)-3098989343984L, (DateUtil.TimeUnit)DateUtil.TimeUnit.SECONDS));
    }

    @Test
    public void testAge() {
        Date dob = DateUtil.toDate((int)27, (int)7, (int)1958);
        Date ref = DateUtil.toDate((int)1, (int)1, (int)2013);
        Assert.assertEquals((Object)"54 yrs", (Object)DateUtil.formatAge((Date)dob, (boolean)true, (Date)ref));
        Assert.assertEquals((Object)"54 yr", (Object)DateUtil.formatAge((Date)dob, (boolean)false, (Date)ref));
        dob = DateUtil.toDate((int)15, (int)12, (int)2012);
        Assert.assertEquals((Object)"17 days", (Object)DateUtil.formatAge((Date)dob, (boolean)true, (Date)ref));
        dob = DateUtil.toDate((int)30, (int)10, (int)2012);
        Assert.assertEquals((Object)"2 mos", (Object)DateUtil.formatAge((Date)dob, (boolean)true, (Date)ref));
    }

    @Test
    public void testStripQuotes() {
        this.testStripQuotes(QT_NONE, QT_NONE);
        this.testStripQuotes(QT_NONE, QT_SINGLE);
        this.testStripQuotes(QT_NONE, QT_DOUBLE);
        this.testStripQuotes(QT_OTHER1, QT_OTHER1);
        this.testStripQuotes(QT_OTHER2, QT_OTHER2);
        this.testStripQuotes(QT_OTHER3, QT_OTHER3);
    }

    private void testStripQuotes(String expected, String value) {
        Assert.assertEquals((Object)expected, (Object)StrUtil.stripQuotes((String)value));
    }

    @Test
    public void testEnquote() {
        this.testEnquote(QT_DOUBLE, QT_NONE, false);
        this.testEnquote(QT_SINGLE, QT_NONE, true);
        this.testEnquote(QT_DOUBLE, QT_DOUBLE, false);
        this.testEnquote(QT_SINGLE, QT_SINGLE, true);
    }

    public void testEnquote(String expected, String value, boolean single) {
        Assert.assertEquals((Object)expected, (Object)(single ? StrUtil.enquoteSingle((String)value) : StrUtil.enquoteDouble((String)value)));
    }

    @Test
    public void testColorUtil() {
        this.testColorUtil("darkorchid", "#9932CC");
        this.testColorUtil("azure", "#F0FFFF");
    }

    public void testColorUtil(String testColor, String testRGB) {
        Color refColor = Color.magenta;
        String rgb = ColorUtil.getRGBFromName((String)testColor);
        Assert.assertEquals((Object)rgb, (Object)testRGB);
        String color = ColorUtil.getNameFromRGB((String)rgb);
        Assert.assertEquals((Object)color.toLowerCase(), (Object)testColor.toLowerCase());
        Color color1 = ColorUtil.toColor((String)rgb, (Color)refColor);
        Color color2 = ColorUtil.toColor((String)color, (Color)refColor);
        Assert.assertEquals((Object)color1, (Object)color2);
        Color color3 = ColorUtil.toColor((String)"badvalue", (Color)refColor);
        Assert.assertEquals((Object)refColor, (Object)color3);
    }

    @Test
    public void testQueryStringBuilder() {
        QueryStringBuilder sb = new QueryStringBuilder();
        Assert.assertEquals((long)0L, (long)sb.length());
        sb.append("q1", new Object[]{"value 1", "value 2"});
        ArrayList<String> list = new ArrayList<String>();
        list.add("value 1");
        list.add("value 2");
        list.add("value 3");
        sb.append("q2", list);
        sb.append("q3", new Object[]{"single"});
        sb.append("q4<>", new Object[]{"escape+name"});
        String qs = sb.toString();
        this.print(qs);
        Assert.assertEquals((Object)"q1=value+1,value+2&q2=value+1&q2=value+2&q2=value+3&q3=single&q4%3C%3E=escape%2Bname", (Object)qs);
        sb.clear();
        Assert.assertTrue((boolean)sb.toString().isEmpty());
    }

    @Test
    public void testListMethods() {
        String original = "1,2,3,4,5";
        List strList = StrUtil.toList((String)original, (String)",");
        Assert.assertEquals((long)5L, (long)strList.size());
        String str = StrUtil.fromList((Iterable)strList, (String)",");
        Assert.assertEquals((Object)original, (Object)str);
        strList = StrUtil.toList((String)",,3,4,5,", (String)",");
        Assert.assertEquals((long)5L, (long)strList.size());
        List<Integer> intList = Arrays.asList(1, 2, 3, 4, 5);
        str = StrUtil.fromList(intList, (String)",");
        Assert.assertEquals((Object)original, (Object)str);
        intList = Arrays.asList(1, 2, null, 4, 5);
        str = StrUtil.fromList(intList, (String)",");
        Assert.assertEquals((Object)"1,2,,4,5", (Object)str);
        str = StrUtil.fromList(intList, (String)",", null);
        Assert.assertEquals((Object)"1,2,4,5", (Object)str);
        str = StrUtil.fromList(intList, (String)",", (String)"3");
        Assert.assertEquals((Object)original, (Object)str);
        ArrayList<Object> iterList = new ArrayList<Object>();
        iterList.add(new Integer(1));
        iterList.add("string #1");
        iterList.add(new Integer(2));
        iterList.add(new Long(1L));
        iterList.add("string #2");
        Iterator iter = MiscUtil.iteratorForType(iterList, Integer.class);
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)1, iter.next());
        iter.remove();
        Assert.assertEquals((Object)2, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)4L, (long)iterList.size());
        int strCount = 0;
        for (String ele : MiscUtil.iterableForType(iterList, String.class)) {
            Assert.assertTrue((boolean)ele.equals("string #" + ++strCount));
        }
        Assert.assertEquals((long)2L, (long)strCount);
    }

    @Test
    public void testObservedList() {
        ArrayList list = new ArrayList();
        final int[] ops = new int[]{0, 0};
        ObservedCollection col = new ObservedCollection(list, (ObservedCollection.IObservedCollectionListener)new ObservedCollection.IObservedCollectionListener<String>(){

            public void onAddElement(String element) {
                ops[0] = ops[0] + 1;
            }

            public void onRemoveElement(String element) {
                ops[1] = ops[1] + 1;
            }
        });
        col.add((Object)"ele1");
        col.add((Object)"ele2");
        col.remove((Object)"ele1");
        col.addAll(Arrays.asList("ele3", "ele4", "ele5"));
        col.removeAll(Arrays.asList("ele1", "ele4"));
        col.retainAll(Arrays.asList("ele1", "ele3"));
        Assert.assertEquals((String)"Add count does not match.", (long)5L, (long)ops[0]);
        Assert.assertEquals((String)"Remove count does not match.", (long)4L, (long)ops[1]);
        col.clear();
        Assert.assertEquals((String)"Add count does not match.", (long)5L, (long)ops[0]);
        Assert.assertEquals((String)"Remove count does not match.", (long)5L, (long)ops[1]);
    }

    @Test
    public void testVersion() {
        Version v1 = new Version(1, 2, 3, 4);
        Version v2 = new Version("1.2.3.4");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = new Version("1.2.3");
        Assert.assertTrue((v1.compareTo(v2) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"1.2.3", (Object)v1.toString());
        Assert.assertEquals((Object)"1.2.3", (Object)v1.toString(Version.VersionPart.RELEASE));
        Assert.assertEquals((Object)"1.2.3.0", (Object)v1.toString(Version.VersionPart.BUILD));
        v1 = new Version("1.0.3");
        Assert.assertEquals((Object)"1.0.3", (Object)v1.toString());
        Assert.assertEquals((Object)"1.0.3.0", (Object)v1.toString(Version.VersionPart.BUILD));
        Assert.assertEquals((Object)"1.0.3", (Object)v1.toString(Version.VersionPart.MINOR));
        Assert.assertEquals((Object)"1.0.3", (Object)v1.toString(Version.VersionPart.RELEASE));
        v2 = new Version("1.0.3b");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = new Version(".5");
        Assert.assertEquals((Object)"0.5", (Object)v1.toString());
        v1 = new Version("");
        Assert.assertEquals((Object)"", (Object)v1.toString());
        v2 = new Version(null);
        Assert.assertEquals((Object)v1, (Object)v2);
    }

    @Test
    public void testBundle() {
        Localizer.registerMessageSource((Localizer.IMessageSource)new BundleMessageSource());
        Locale locale1 = new Locale("en");
        Locale locale2 = new Locale("fr");
        Assert.assertEquals((Object)"keyboard", (Object)StrUtil.getLabel((String)"message.test1", (Locale)locale1, (Object[])new Object[0]));
        Assert.assertEquals((Object)"clavier", (Object)StrUtil.getLabel((String)"message.test1", (Locale)locale2, (Object[])new Object[0]));
    }

    @Test
    public void testWeakCollections() {
        WeakList list = new WeakList();
        WeakMap map = new WeakMap();
        Object o1 = new Object();
        Object o2 = new Object();
        list.add(o1);
        list.add(o2);
        map.put("o1", o1);
        map.put("o2", o2);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)map.size());
        o1 = null;
        System.gc();
        this.wait(3000);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testCamelCase() {
        this.testCamelCase(" test of _camel_case  ");
        this.testCamelCase("TEST OF CAMEL CASE");
        this.testCamelCase("test_of_camel_case");
        this.testCamelCase("test__of_ camel\t\ncase");
        this.testCamelCase("test of camel case");
    }

    private void testCamelCase(String text) {
        Assert.assertEquals((Object)CAMEL_UCASE_RESULT, (Object)StrUtil.toCamelCaseUpper((String)text));
        Assert.assertEquals((Object)CAMEL_LCASE_RESULT, (Object)StrUtil.toCamelCaseLower((String)text));
    }

    @Test
    public void testCyclicIterator() {
        CyclicIterator iter = new CyclicIterator((Object[])CYCLIC_COLLECTION);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Assert.assertEquals((long)j, (long)((Integer)iter.next()).intValue());
            }
        }
    }

    private void wait(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void print(Object object) {
        System.out.println(object);
    }
}

