/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.fujion.common.RegistryMap;

public abstract class AbstractRegistry<KEY, VALUE>
implements Iterable<VALUE> {
    protected final Map<KEY, VALUE> map;

    protected AbstractRegistry() {
        this(null);
    }

    protected AbstractRegistry(RegistryMap.DuplicateAction duplicateAction) {
        this(null, duplicateAction);
    }

    protected AbstractRegistry(Map<KEY, VALUE> map, RegistryMap.DuplicateAction duplicateAction) {
        this.map = new RegistryMap<KEY, VALUE>(map, duplicateAction);
    }

    protected abstract KEY getKey(VALUE var1);

    public VALUE get(KEY key) {
        return this.map.get(key);
    }

    public boolean contains(KEY key) {
        return this.map.containsKey(key);
    }

    public Collection<VALUE> getAll() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public void register(VALUE item) {
        if (item != null) {
            this.map.put(this.getKey(item), item);
        }
    }

    public VALUE unregister(VALUE item) {
        return this.unregisterByKey(this.getKey(item));
    }

    public VALUE unregisterByKey(KEY key) {
        return this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<VALUE> iterator() {
        return this.map.values().iterator();
    }
}

