/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.common.ILogger;

public class Logger
implements ILogger {
    private final Log log;

    public static Logger create(Class<?> clazz) {
        return Logger.create(LogFactory.getLog(clazz));
    }

    public static Logger create(String name) {
        return Logger.create(LogFactory.getLog((String)name));
    }

    public static Logger create(Log log) {
        return log instanceof Logger ? (Logger)log : new Logger(log);
    }

    private Logger(Log log) {
        this.log = log;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void debug(Object message) {
        this.log.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.log.debug(message, t);
    }

    public void error(Object message) {
        this.log.error(message);
    }

    public void error(Object message, Throwable t) {
        this.log.error(message, t);
    }

    public void fatal(Object message) {
        this.log.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.log.fatal(message, t);
    }

    public void info(Object message) {
        this.log.info(message);
    }

    public void info(Object message, Throwable t) {
        this.log.info(message, t);
    }

    public void trace(Object message) {
        this.log.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.log.trace(message, t);
    }

    public void warn(Object message) {
        this.log.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.log.warn(message, t);
    }
}

