/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.UnhandledException;

public class MiscUtil {
    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static boolean containsInstance(List<?> list, Object object) {
        return MiscUtil.indexOfInstance(list, object) > -1;
    }

    public static int indexOfInstance(List<?> list, Object object) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    public static <T, S> List<S> castList(List<T> list, Class<S> clazz) {
        return (List)MiscUtil.castCollection(list, clazz);
    }

    public static <CT extends Collection<T>, CS extends Collection<S>, T, S> CS castCollection(CT collection, Class<S> clazz) {
        return (CS)collection;
    }

    public static <T, S extends T> Iterator<S> iteratorForType(Collection<T> collection, Class<S> type) {
        return MiscUtil.iteratorForType(collection.iterator(), type);
    }

    public static <T, S extends T> Iterator<S> iteratorForType(Iterator<T> iterator, Class<S> type) {
        return iterator instanceof ListIterator ? IteratorUtils.filteredListIterator((ListIterator)((ListIterator)iterator), element -> type.isInstance(element)) : IteratorUtils.filteredIterator(iterator, element -> type.isInstance(element));
    }

    public static <T, S extends T> Iterable<S> iterableForType(Collection<T> collection, Class<S> type) {
        return () -> MiscUtil.iteratorForType(collection, type);
    }

    public static boolean intersects(Object[] ary1, Object[] ary2) {
        return MiscUtil.intersects(Arrays.asList(ary1), Arrays.asList(ary2));
    }

    public static boolean intersects(Iterable<?> iter1, Iterable<?> iter2) {
        for (Object obj1 : iter1) {
            for (Object obj2 : iter2) {
                if (!ObjectUtils.equals(obj1, obj2)) continue;
                return true;
            }
        }
        return false;
    }

    public static RuntimeException toUnchecked(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new UnhandledException(e);
    }

    public static Class<?>[] getParameterTypes(Object ... parameters) {
        int len = parameters == null ? 0 : parameters.length;
        Class[] parameterTypes = new Class[len];
        for (int i = 0; i < len; ++i) {
            parameterTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return parameterTypes;
    }

    public static Pattern globToRegex(String glob) {
        StringBuilder sb = new StringBuilder(glob.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = glob.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append("[^/]*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append("[^/]");
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return Pattern.compile(sb.toString());
    }

    private MiscUtil() {
    }
}

