/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.fujion.common.MiscUtil;

public abstract class AbstractCache<KEY, VALUE>
implements Iterable<VALUE> {
    private final Map<KEY, CachedObject<VALUE>> map = new ConcurrentHashMap<KEY, CachedObject<VALUE>>();

    protected abstract VALUE fetch(KEY var1);

    public VALUE get(KEY key) {
        return this.isCached(key) ? this.map.get(key).getObject() : this.internalGet(key);
    }

    public boolean isCached(KEY key) {
        return this.map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VALUE internalGet(KEY key) {
        CachedObject<VALUE> cachedObject;
        boolean needsFetch;
        Map<KEY, CachedObject<VALUE>> map = this.map;
        synchronized (map) {
            boolean bl = needsFetch = !this.map.containsKey(key);
            if (needsFetch) {
                cachedObject = new CachedObject<VALUE>();
                this.map.put(key, cachedObject);
            } else {
                cachedObject = this.map.get(key);
            }
        }
        if (needsFetch) {
            try {
                cachedObject.setObject(this.fetch(key));
            }
            catch (Throwable e) {
                RuntimeException e2 = MiscUtil.toUnchecked(e);
                cachedObject.setException(e2);
                throw e2;
            }
        }
        return cachedObject.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Map<KEY, CachedObject<VALUE>> map = this.map;
        synchronized (map) {
            HashSet<KEY> contents = new HashSet<KEY>(this.map.keySet());
            this.clear();
            for (Object key : contents) {
                this.internalGet(key);
            }
        }
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<VALUE> iterator() {
        return new Iterator<VALUE>(){
            final Iterator<CachedObject<VALUE>> iterator;
            {
                this.iterator = AbstractCache.this.map.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public VALUE next() {
                return this.iterator.next().getObject();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.map.size();
    }

    private static class CachedObject<VALUE> {
        private VALUE object;
        private RuntimeException exception;
        private ReentrantLock lock = new ReentrantLock();

        private CachedObject() {
            this.lock.lock();
        }

        void setObject(VALUE object) {
            this.object = object;
            this.removeLock();
        }

        void setException(RuntimeException exception) {
            this.exception = exception;
            this.removeLock();
        }

        VALUE getObject() {
            if (this.exception != null) {
                throw this.exception;
            }
            this.lock();
            this.unlock();
            return this.object;
        }

        private void removeLock() {
            ReentrantLock lock = this.lock;
            this.lock = null;
            lock.unlock();
        }

        private void lock() {
            if (this.lock != null) {
                this.lock.lock();
            }
        }

        private void unlock() {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }
}

