/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.fujion.common.RegistryMap;

public abstract class AbstractRegistry<KEY, VALUE>
implements Iterable<VALUE> {
    protected final Map<KEY, VALUE> map;

    protected AbstractRegistry() {
        this(null);
    }

    protected AbstractRegistry(RegistryMap.DuplicateAction duplicateAction) {
        this(null, duplicateAction);
    }

    protected AbstractRegistry(Map<KEY, VALUE> map, RegistryMap.DuplicateAction duplicateAction) {
        this.map = new RegistryMap<KEY, VALUE>(map, duplicateAction);
    }

    protected abstract KEY getKey(VALUE var1);

    public VALUE get(KEY key) {
        return this.map.get(key);
    }

    public boolean contains(KEY key) {
        return this.map.containsKey(key);
    }

    public Collection<VALUE> getAll() {
        return this.map.values();
    }

    public void register(VALUE item) {
        if (item != null) {
            KEY key = this.getKey(item);
            this.map.put(key, item);
            this.onRegister(key, item);
        }
    }

    protected void onRegister(KEY key, VALUE value) {
    }

    public VALUE unregister(VALUE item) {
        return this.unregisterByKey(this.getKey(item));
    }

    public VALUE unregisterByKey(KEY key) {
        VALUE value = this.map.remove(key);
        if (value != null) {
            this.onUnregister(key, value);
        }
        return value;
    }

    protected void onUnregister(KEY key, VALUE value) {
    }

    protected void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<VALUE> iterator() {
        return this.map.values().iterator();
    }
}

