/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;

public class CollectionUtil {
    public static <T> T getFirst(Collection<T> source) {
        return source == null ? null : source.stream().findFirst().orElse(null);
    }

    public static boolean isEmpty(Collection<?> source) {
        return source == null || source.isEmpty();
    }

    public static boolean notEmpty(Collection<?> source) {
        return !CollectionUtil.isEmpty(source);
    }

    public static boolean containsInstance(List<?> list, Object object) {
        return CollectionUtil.indexOfInstance(list, object) > -1;
    }

    public static int indexOfInstance(List<?> list, Object object) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    public static <T, S> List<S> castList(List<T> list, Class<S> clazz) {
        return (List)CollectionUtil.castCollection(list, clazz);
    }

    public static <CT extends Collection<T>, CS extends Collection<S>, T, S> CS castCollection(CT collection, Class<S> clazz) {
        return (CS)collection;
    }

    public static <T, S extends T> Iterator<S> iteratorForType(Collection<T> collection, Class<S> type) {
        return CollectionUtil.iteratorForType(collection.iterator(), type);
    }

    public static <T, S extends T> Iterator<S> iteratorForType(Iterator<T> iterator, Class<S> type) {
        Iterator iter = iterator instanceof ListIterator ? IteratorUtils.filteredListIterator((ListIterator)((ListIterator)iterator), type::isInstance) : IteratorUtils.filteredIterator(iterator, type::isInstance);
        return iter;
    }

    public static <T, S extends T> Iterable<S> iterableForType(Collection<T> collection, Class<S> type) {
        return () -> CollectionUtil.iteratorForType(collection, type);
    }

    public static boolean intersects(Object[] ary1, Object[] ary2) {
        return CollectionUtil.intersects(Arrays.asList(ary1), Arrays.asList(ary2));
    }

    public static boolean intersects(Iterable<?> iter1, Iterable<?> iter2) {
        for (Object obj1 : iter1) {
            for (Object obj2 : iter2) {
                if (!Objects.equals(obj1, obj2)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> List<T> toList(T ... elements) {
        return elements == null ? null : Arrays.asList(elements);
    }

    public static <T> List<T> ensureList(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> List<T> replaceElements(List<T> dest, Collection<T> source) {
        Collection collection = source = source == null ? Collections.emptyList() : source;
        if (dest == null) {
            dest = new ArrayList<T>(source);
        } else {
            dest.clear();
            dest.addAll(source);
        }
        return dest;
    }

    public static <T> List<T> replaceElements(List<T> dest, T ... elements) {
        return CollectionUtil.replaceElements(dest, elements == null ? null : Arrays.asList(elements));
    }

    public static <T> T findMatch(Collection<T> source, Predicate<T> criteria) {
        return source == null ? null : source.stream().filter(criteria).findFirst().orElse(null);
    }

    public static <T, I> T findMatch(Collection<T> source, BiPredicate<T, I> criteria, I ... items) {
        if (source != null && !source.isEmpty()) {
            for (Object item : items) {
                T match = source.stream().filter(element -> criteria.test(element, item)).findFirst().orElse(null);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    public static <T> List<T> findMatches(Collection<T> source, Predicate<T> criteria) {
        return source.stream().filter(criteria).collect(Collectors.toList());
    }

    private CollectionUtil() {
    }
}

