/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Date;
import org.fujion.common.DateUtil;
import org.fujion.common.MiscUtil;

public class DateTimeWrapper
implements Comparable<DateTimeWrapper> {
    private final Temporal temporal;

    public static DateTimeWrapper now() {
        return new DateTimeWrapper(LocalDateTime.now());
    }

    public static DateTimeWrapper today() {
        return new DateTimeWrapper(LocalDate.now());
    }

    public static DateTimeWrapper parse(String value) {
        Date date = DateUtil.parseDate(value);
        MiscUtil.assertTrue(date != null, () -> "Unable to parse input '" + value + "'.");
        return new DateTimeWrapper(date);
    }

    public DateTimeWrapper(LocalDate date) {
        this.temporal = this.validateTemporal(date);
    }

    public DateTimeWrapper(LocalDateTime datetime) {
        this.temporal = this.validateTemporal(datetime);
    }

    public DateTimeWrapper(Date date) {
        this.temporal = this.validateTemporal((Temporal)((Object)(DateUtil.hasTime(date) ? DateUtil.toLocalDateTime(date) : DateUtil.toLocalDate(date))));
    }

    public boolean hasTime() {
        return this.temporal instanceof LocalDateTime;
    }

    public Date getLegacyDate() {
        return DateUtil.toDate(this.temporal);
    }

    public LocalDateTime getDateTime() {
        return this.hasTime() ? (LocalDateTime)this.temporal : ((LocalDate)this.temporal).atStartOfDay();
    }

    public LocalDate getDate() {
        return this.hasTime() ? ((LocalDateTime)this.temporal).toLocalDate() : (LocalDate)this.temporal;
    }

    public LocalTime getTime() {
        return this.hasTime() ? ((LocalDateTime)this.temporal).toLocalTime() : null;
    }

    private Temporal validateTemporal(Temporal temporal) {
        MiscUtil.assertTrue(temporal != null, "Date/time value must not be null.");
        return temporal;
    }

    @Override
    public int compareTo(DateTimeWrapper dtw) {
        if (!this.hasTime() && !dtw.hasTime()) {
            return this.getDate().compareTo(dtw.getDate());
        }
        return this.getDateTime().compareTo(dtw.getDateTime());
    }

    public String toISOString() {
        return this.hasTime() ? DateTimeFormatter.ISO_DATE_TIME.format(this.temporal) : DateTimeFormatter.ISO_DATE.format(this.temporal);
    }

    public String toString() {
        return DateUtil.formatDate(this.temporal);
    }
}

