/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.fujion.common.Localizer;

public class DateUtil {
    private static final String HL7_DATE_ONLY_PATTERN = "yyyyMMdd";
    private static final String HL7_DATE_TIME_PATTERN = "yyyyMMddHHmmssz";
    private static final String UNKNOWN = "Unknown";
    private static final Pattern PATTERN_EXT_DATE = Pattern.compile("^\\s*[tn]{1}\\s*([+-]{1}\\s*[\\d]*\\s*[snhdmy]?)?\\s*$");
    private static final Pattern PATTERN_SPECIFIES_UNITS = Pattern.compile("^.*[snhdmy]$");
    private static final Pattern PATTERN_NUMERIC_PREFIX = Pattern.compile("^-?[\\d.]+");
    private static final double[] MS_FP = new double[]{3.15576E10, 2.592E9, 6.048E8, 8.64E7, 3600000.0, 60000.0, 1000.0, 1.0};
    private static final long[] MS_LG = new long[]{31557600000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L, 1000L, 1L};
    public static String[][] TIME_UNIT = new String[][]{{"year", "years", "yr", "yrs"}, {"month", "months", "mo", "mos"}, {"week", "weeks", "wk", "wks"}, {"day", "days", "day", "days"}, {"hour", "hours", "hr", "hrs"}, {"minute", "minutes", "min", "mins"}, {"second", "seconds", "sec", "secs"}, {"millisecond", "milliseconds", "ms", "ms"}};
    private static final ThreadLocal<DecimalFormat> decimalFormat = ThreadLocal.withInitial(() -> new DecimalFormat("##0.##"));

    public static String formatElapsed(double elapsed) {
        return DateUtil.formatElapsed(elapsed, true, false, false);
    }

    public static String formatElapsed(double elapsed, TimeUnit minUnits) {
        return DateUtil.formatElapsed(elapsed, true, false, false, minUnits);
    }

    public static String formatElapsed(double elapsed, boolean pluralize, boolean abbreviated, boolean round) {
        return DateUtil.formatElapsed(elapsed, pluralize, abbreviated, round, null);
    }

    public static String formatElapsed(double elapsed, boolean pluralize, boolean abbreviated, boolean round, TimeUnit minUnits) {
        int index = (minUnits == null ? TimeUnit.MILLISECONDS : minUnits).ordinal();
        String prefix = "";
        if (elapsed < 0.0) {
            elapsed = -elapsed;
            prefix = "-";
        }
        for (int i = 0; i <= index; ++i) {
            if (!(elapsed >= MS_FP[i]) && i != index) continue;
            elapsed /= MS_FP[i];
            index = i;
            break;
        }
        if (round) {
            elapsed = Math.floor(elapsed);
        }
        return prefix + decimalFormat.get().format(elapsed) + " " + DateUtil.getDurationUnits(index, pluralize && elapsed != 1.0, abbreviated);
    }

    public static double parseElapsed(String value) {
        return DateUtil.parseElapsed(value, TimeUnit.MILLISECONDS);
    }

    public static double parseElapsed(String value, TimeUnit units) {
        double result;
        Matcher matcher = PATTERN_NUMERIC_PREFIX.matcher(value);
        if (!matcher.find()) {
            return 0.0;
        }
        int i = matcher.end();
        try {
            result = Double.parseDouble(value.substring(0, i));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
        value = value.substring(i).trim().toLowerCase();
        for (TimeUnit tu : TimeUnit.values()) {
            for (String unit : TIME_UNIT[tu.ordinal()]) {
                if (!unit.equals(value)) continue;
                result *= MS_FP[tu.ordinal()];
                if (units != null && units != TimeUnit.MILLISECONDS) {
                    result /= MS_FP[units.ordinal()];
                }
                return result;
            }
        }
        return 0.0;
    }

    public static String formatDuration(long duration) {
        return DateUtil.formatDuration(duration, null);
    }

    public static String formatDuration(long duration, TimeUnit accuracy) {
        return DateUtil.formatDuration(duration, accuracy, true, false);
    }

    public static String formatDuration(long duration, TimeUnit accuracy, boolean pluralize, boolean abbreviated) {
        StringBuilder sb = new StringBuilder();
        if (duration < 0L) {
            duration = -duration;
            sb.append('-');
        }
        accuracy = accuracy == null ? TimeUnit.MILLISECONDS : accuracy;
        int last = accuracy.ordinal();
        boolean empty = true;
        for (int i = 0; i <= last; ++i) {
            long val = duration / MS_LG[i];
            duration -= val * MS_LG[i];
            if (val == 0L && (!empty || i != last)) continue;
            if (!empty) {
                sb.append(' ');
            } else {
                empty = false;
            }
            sb.append(val).append(' ').append(DateUtil.getDurationUnits(i, pluralize && val != 1L, abbreviated));
        }
        return sb.toString();
    }

    private static String getDurationUnits(TimeUnit accuracy, boolean plural, boolean abbreviated) {
        return DateUtil.getDurationUnits(accuracy.ordinal(), plural, abbreviated);
    }

    private static String getDurationUnits(int index, boolean plural, boolean abbreviated) {
        int which = (plural ? 1 : 0) + (abbreviated ? 2 : 0);
        return TIME_UNIT[index][which];
    }

    private static int getAgeInYears(int birthYear, int birthMonth, int birthDay, int refYear, int refMonth, int refDay) {
        if (refMonth > birthMonth || refMonth == birthMonth && refDay >= birthDay) {
            return refYear - birthYear;
        }
        return refYear - birthYear - 1;
    }

    private static String formatUnits(long value, TimeUnit accuracy, boolean pluralize) {
        return value + " " + DateUtil.getDurationUnits(accuracy, pluralize && value != 1L, true);
    }

    public static TimeZone getLocalTimeZone() {
        return Localizer.getTimeZone();
    }

    public static ZoneId getLocalZoneId() {
        return DateUtil.getLocalTimeZone().toZoneId();
    }

    public static Date cloneDate(Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static Date addDays(Date date, int daysOffset, boolean stripTime) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        if (stripTime) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        calendar.add(5, daysOffset);
        return calendar.getTime();
    }

    public static Date stripTime(Date date) {
        return DateUtil.addDays(date, 0, true);
    }

    public static Date endOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date now() {
        return new Date();
    }

    public static Date today() {
        return DateUtil.stripTime(DateUtil.now());
    }

    public static int compare(Date date1, Date date2) {
        long diff;
        long l = date1 == date2 ? 0L : (date1 == null ? -1L : (diff = date2 == null ? 1L : date1.getTime() - date2.getTime()));
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, false, false);
    }

    public static String formatDate(Date date, boolean showTimezone) {
        return DateUtil.formatDate(date, showTimezone, false);
    }

    public static String formatDate(Date date, boolean showTimezone, boolean ignoreTime) {
        boolean bl = ignoreTime = ignoreTime || !DateUtil.hasTime(date);
        Format format = ignoreTime ? Format.WITHOUT_TIME : (showTimezone ? Format.WITH_TZ : Format.WITHOUT_TZ);
        return format.formatDate(date);
    }

    public static String formatDate(Date date, String timeSeparator) {
        return DateUtil.formatDate(date).replaceFirst(" ", timeSeparator);
    }

    public static String toHL7(Date date) {
        Format format = DateUtil.hasTime(date) ? Format.HL7_WITHOUT_TIME : Format.HL7;
        return format.formatDate(date);
    }

    public static String toISODate(Date date) {
        return DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(date);
    }

    public static String toISODateTime(Date date) {
        return DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(date);
    }

    public static boolean hasTime(Date date) {
        long time2;
        if (date == null) {
            return false;
        }
        long time1 = date.getTime();
        return time1 != (time2 = DateUtil.stripTime(date).getTime());
    }

    public static Date parseDate(String s) {
        Date result = null;
        if (s != null && !s.isEmpty()) {
            if (PATTERN_EXT_DATE.matcher(s = s.toLowerCase()).matches()) {
                try {
                    s = s.replaceAll("\\s+", "");
                    String _k = s.substring(1);
                    int k = 100;
                    if (1 == s.length()) {
                        _k = "0";
                    } else if (PATTERN_SPECIFIES_UNITS.matcher(s).matches()) {
                        _k = s.substring(1, s.length() - 1);
                        k = s.charAt(s.length() - 1);
                    }
                    if ('+' == _k.charAt(0)) {
                        _k = _k.substring(1);
                    }
                    int field = 6;
                    int offset = Integer.parseInt(_k);
                    Calendar c = Calendar.getInstance();
                    c.setLenient(false);
                    if (s.charAt(0) == 't') {
                        c.setTime(DateUtil.today());
                    }
                    switch (k) {
                        case 121: {
                            field = 1;
                            break;
                        }
                        case 109: {
                            field = 2;
                            break;
                        }
                        case 104: {
                            field = 11;
                            break;
                        }
                        case 110: {
                            field = 12;
                            break;
                        }
                        case 115: {
                            field = 13;
                        }
                    }
                    c.add(field, offset);
                    result = c.getTime();
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                result = DateUtil.tryParse(s);
                if (result != null) {
                    return result;
                }
                result = DateUtil.tryParse(s = s.replaceAll("[.-]", "/"));
                if (result != null) {
                    return result;
                }
                s = s.replaceAll("\\s", "/");
                result = DateUtil.tryParse(s);
            }
        }
        return result;
    }

    public static Date parseDate(String value, String ... patterns) throws ParseException {
        return DateUtils.parseDate((String)value, (String[])patterns);
    }

    private static Date tryParse(String value) {
        for (Format format : Format.values()) {
            try {
                return format.parseAsDate(value);
            }
            catch (Exception exception) {
            }
        }
        for (int i = 3; i >= 0; --i) {
            try {
                return DateFormat.getDateInstance(i).parse(value);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static String formatAge(Date dob) {
        return DateUtil.formatAge(dob, true, null);
    }

    public static String formatAge(Date dob, boolean pluralize, Date refDate) {
        if (dob == null) {
            return UNKNOWN;
        }
        Calendar asOf = Calendar.getInstance();
        asOf.setTimeInMillis(refDate == null ? System.currentTimeMillis() : refDate.getTime());
        Calendar bd = Calendar.getInstance();
        bd.setTime(dob);
        long birthDateInDays = (asOf.getTimeInMillis() - bd.getTimeInMillis()) / 1000L / 60L / 60L / 24L;
        if (birthDateInDays < 0L) {
            return UNKNOWN;
        }
        if (birthDateInDays <= 1L) {
            return "newborn";
        }
        if (birthDateInDays <= 60L) {
            return DateUtil.formatUnits(birthDateInDays, TimeUnit.DAYS, pluralize);
        }
        int birthYear = bd.get(1);
        int birthMonth = bd.get(2);
        int birthDay = bd.get(5);
        int refYear = asOf.get(1);
        int refMonth = asOf.get(2);
        int refDay = asOf.get(5);
        if (birthDateInDays <= 730L) {
            if (refMonth >= birthMonth && refDay >= birthDay) {
                return DateUtil.formatUnits((refYear - birthYear) * 12 + refMonth - birthMonth, TimeUnit.MONTHS, pluralize);
            }
            return DateUtil.formatUnits((refYear - birthYear) * 12 + refMonth - birthMonth - 1, TimeUnit.MONTHS, pluralize);
        }
        return DateUtil.formatUnits(DateUtil.getAgeInYears(birthYear, birthMonth, birthDay, refYear, refMonth, refDay), TimeUnit.YEARS, pluralize);
    }

    public static Date toDate(int day, int month, int year) {
        return DateUtil.toDate(day, month, year, 0, 0, 0);
    }

    public static Date toDate(int day, int month, int year, int hr, int min, int sec) {
        Calendar cal = Calendar.getInstance(Localizer.getTimeZone());
        cal.set(year, month - 1, day, hr, min, sec);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String formatDate(Temporal temporal) {
        Format format = null;
        if (temporal instanceof LocalDate) {
            format = Format.WITHOUT_TIME;
        } else if (temporal instanceof LocalDateTime) {
            format = Format.WITHOUT_TZ;
        } else if (temporal instanceof LocalTime) {
            format = Format.WITHOUT_DATE;
        }
        return format == null ? "" : format.formatDate(temporal);
    }

    public static String toISODate(Temporal date) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    public static String toISODateTime(Temporal date) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(date);
    }

    public static LocalDate toLocalDate(Date date) {
        return date == null ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date == null ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(Temporal localDate) {
        if (localDate == null) {
            return null;
        }
        if (localDate instanceof LocalDateTime) {
            return DateUtil.toDate((LocalDateTime)localDate);
        }
        if (localDate instanceof LocalDate) {
            return DateUtil.toDate((LocalDate)localDate);
        }
        throw new IllegalArgumentException("Unsupported date type: " + localDate.getClass());
    }

    public static Date toDate(LocalDate localDate) {
        return localDate == null ? null : Date.from(localDate.atStartOfDay(DateUtil.getLocalZoneId()).toInstant());
    }

    public static Date toDate(LocalDateTime localDate) {
        return localDate == null ? null : Date.from(localDate.atZone(DateUtil.getLocalZoneId()).toInstant());
    }

    public static String formatAge(Temporal dob) {
        return DateUtil.formatAge(dob, true, null);
    }

    public static String formatAge(Temporal dob, boolean pluralize, Temporal refDate) {
        return DateUtil.formatAge(DateUtil.toDate(dob), pluralize, DateUtil.toDate(refDate));
    }

    public static LocalDateTime parseLocalDate(String s) {
        return DateUtil.toLocalDateTime(DateUtil.parseDate(s));
    }

    private DateUtil() {
    }

    public static enum Format {
        WITH_TZ("dd-MMM-yyyy HH:mm zzz"),
        WITHOUT_TZ("dd-MMM-yyyy HH:mm"),
        WITHOUT_TIME("dd-MMM-yyyy"),
        WITHOUT_DATE("HH:mm"),
        HL7("yyyyMMddHHmmssz"),
        HL7_WITHOUT_TIME("yyyyMMdd"),
        JS_WITH_TZ("yyyy-MM-dd HH:mm zzz"),
        JS_WITHOUT_TZ("yyyy-MM-dd HH:mm"),
        JS_WITHOUT_TIME("yyyy-MM-dd"),
        TO_STRING("EEE MMM dd HH:mm:ss zzz yyyy");

        private static final Map<ZoneId, DateTimeFormatter> formatterCache;
        private final boolean noTime;
        private final String pattern;
        private final DateTimeFormatter temporalFormatter;

        private Format(String pattern) {
            this.pattern = pattern;
            this.noTime = !pattern.contains(":");
            this.temporalFormatter = DateTimeFormatter.ofPattern(pattern);
        }

        private TimeZone getTimeZone() {
            return this.noTime ? TimeZone.getDefault() : DateUtil.getLocalTimeZone();
        }

        public String getPattern() {
            return this.pattern;
        }

        public String formatDate(Date date) {
            return date == null ? "" : FastDateFormat.getInstance((String)this.pattern, (TimeZone)this.getTimeZone()).format(date);
        }

        public String formatDate(Temporal date) {
            if (date == null) {
                return "";
            }
            ZoneId zoneId = this.getTimeZone().toZoneId();
            DateTimeFormatter formatter = formatterCache.get(zoneId);
            if (formatter == null) {
                formatter = this.temporalFormatter.withZone(zoneId);
                formatterCache.put(zoneId, formatter);
            }
            return formatter.format(date);
        }

        public Date parseAsDate(String value) throws ParseException {
            return DateUtil.parseDate(value, this.pattern);
        }

        public LocalDate parseAsLocalDate(String value) throws ParseException {
            return DateUtil.toLocalDate(DateUtil.parseDate(value, this.pattern));
        }

        public LocalDateTime parseAsLocalDateTime(String value) throws ParseException {
            return DateUtil.toLocalDateTime(DateUtil.parseDate(value, this.pattern));
        }

        static {
            formatterCache = new ConcurrentHashMap<ZoneId, DateTimeFormatter>();
        }
    }

    public static enum TimeUnit {
        YEARS,
        MONTHS,
        WEEKS,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS,
        MILLISECONDS;

    }
}

