/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fujion.common.MiscUtil;

public class JSONUtil {
    private static final String DEFAULT_TYPE_PROPERTY = "@class";
    private static final Map<String, ObjectMapper> mappers = new ConcurrentHashMap<String, ObjectMapper>();
    private static final Map<String, Class<?>> aliasToClass = new HashMap();
    private static final Map<Class<?>, String> classToAlias = new HashMap();

    public static ObjectMapper getMapper() {
        return JSONUtil.getMapper(null);
    }

    public static ObjectMapper getMapper(String typeProperty) {
        typeProperty = typeProperty == null ? DEFAULT_TYPE_PROPERTY : typeProperty;
        ObjectMapper mapper = mappers.get(typeProperty);
        return mapper == null ? JSONUtil.initMapper(typeProperty) : mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectMapper initMapper(String typeProperty) {
        Map<String, ObjectMapper> map = mappers;
        synchronized (map) {
            ObjectMapper mapper = mappers.get(typeProperty);
            if (mapper == null) {
                mapper = new ObjectMapper();
                CWTypeResolverBuilder typer = new CWTypeResolverBuilder();
                typer = typer.init(JsonTypeInfo.Id.CUSTOM, new CWTypedIdResolver());
                typer = typer.inclusion(JsonTypeInfo.As.PROPERTY);
                typer = typer.typeProperty(typeProperty);
                mapper.setDefaultTyping((TypeResolverBuilder)typer);
                mappers.put(typeProperty, mapper);
            }
            return mapper;
        }
    }

    public static synchronized void registerAlias(String alias, Class<?> clazz) {
        if (aliasToClass.containsKey(alias) && aliasToClass.get(alias) != clazz) {
            throw new RuntimeException("Alias '" + alias + "' is already registered to another class.");
        }
        if (classToAlias.containsKey(clazz) && classToAlias.get(clazz).equals(alias)) {
            throw new RuntimeException("Class '" + clazz.getName() + "' is already registered to another alias.");
        }
        aliasToClass.put(alias, clazz);
        classToAlias.put(clazz, alias);
    }

    public static synchronized void unregisterAlias(String name) {
        classToAlias.remove(aliasToClass.get(name));
        aliasToClass.remove(name);
    }

    public static String getAlias(Class<?> clazz) {
        return classToAlias.get(clazz);
    }

    private static String findId(Class<?> clazz) {
        String id = classToAlias.get(clazz);
        return id == null ? clazz.getName() : id;
    }

    public static void setDateFormat(DateFormat dateFormat) {
        JSONUtil.setDateFormat(null, dateFormat);
    }

    public static void setDateFormat(String typeProperty, DateFormat dateFormat) {
        JSONUtil.getMapper(typeProperty).setDateFormat(dateFormat);
    }

    public static String serialize(Object object) {
        return JSONUtil.serialize(object, false);
    }

    public static String serialize(Object object, boolean prettyPrint) {
        return JSONUtil.serialize(null, object, prettyPrint);
    }

    public static String serialize(String typeProperty, Object object) {
        return JSONUtil.serialize(typeProperty, object, false);
    }

    public static String serialize(String typeProperty, Object object, boolean prettyPrint) {
        try {
            ObjectMapper mapper = JSONUtil.getMapper(typeProperty);
            return prettyPrint ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object) : mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object deserialize(String data) {
        return JSONUtil.deserialize(null, data);
    }

    public static Object deserialize(String typeProperty, String data) {
        if (data == null) {
            return null;
        }
        if (data.startsWith("[")) {
            return JSONUtil.deserializeList(typeProperty, data, Object.class);
        }
        try {
            return JSONUtil.getMapper(typeProperty).readValue(data, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> deserializeList(String data, Class<T> clazz) {
        return JSONUtil.deserializeList(null, data, clazz);
    }

    public static <T> List<T> deserializeList(String typeProperty, String data, Class<T> clazz) {
        try {
            return (List)JSONUtil.getMapper(typeProperty).readValue(data, new TypeReference<List<T>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode merge(JsonNode destNode, JsonNode srcNode) {
        return JSONUtil.merge(destNode, srcNode, false);
    }

    public static JsonNode merge(JsonNode destNode, JsonNode srcNode, boolean deleteOnNull) {
        if (srcNode != null) {
            Iterator fieldNames = srcNode.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode jsonNode = destNode.get(fieldName);
                if (jsonNode != null && jsonNode.isObject()) {
                    JSONUtil.merge(jsonNode, srcNode.get(fieldName), deleteOnNull);
                    continue;
                }
                if (!(destNode instanceof ObjectNode)) continue;
                JsonNode value = srcNode.get(fieldName);
                if (deleteOnNull && value.isNull()) {
                    ((ObjectNode)destNode).remove(fieldName);
                    continue;
                }
                ((ObjectNode)destNode).set(fieldName, value);
            }
        }
        return destNode;
    }

    private JSONUtil() {
    }

    public static final class AsPropertyTypeSerializerEx
    extends AsPropertyTypeSerializer {
        public AsPropertyTypeSerializerEx(TypeIdResolver idRes, BeanProperty property, String propName) {
            super(idRes, property, propName);
        }

        public WritableTypeId writeTypePrefix(JsonGenerator jgen, WritableTypeId typeId) throws IOException {
            if (typeId.valueShape == JsonToken.START_OBJECT && !jgen.getOutputContext().inRoot() && !jgen.getOutputContext().inArray()) {
                typeId.include = WritableTypeId.Inclusion.PAYLOAD_PROPERTY;
            }
            return super.writeTypePrefix(jgen, typeId);
        }
    }

    private static class CWTypedIdResolver
    implements TypeIdResolver {
        private JavaType baseType;

        protected CWTypedIdResolver() {
        }

        public void init(JavaType baseType) {
            this.baseType = baseType;
        }

        public String idFromValue(Object value) {
            return JSONUtil.findId(value.getClass());
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            return JSONUtil.findId(suggestedType);
        }

        public String idFromBaseType() {
            return JSONUtil.findId(this.baseType.getRawClass());
        }

        public JavaType typeFromId(DatabindContext context, String id) {
            return this.typeFromId(context.getTypeFactory(), id);
        }

        private JavaType typeFromId(TypeFactory typeFactory, String id) {
            try {
                Class clazz = (Class)aliasToClass.get(id);
                clazz = clazz == null ? typeFactory.findClass(id) : clazz;
                return typeFactory.constructType((Type)clazz);
            }
            catch (ClassNotFoundException e) {
                throw MiscUtil.toUnchecked(e);
            }
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.CUSTOM;
        }

        public String getDescForKnownTypeIds() {
            return "CWTypeResolverBuilder";
        }
    }

    private static class CWTypeResolverBuilder
    extends StdTypeResolverBuilder {
        private CWTypeResolverBuilder() {
        }

        public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
            return this.noTypeInfo(baseType) ? null : new AsPropertyTypeDeserializer(baseType, this._customIdResolver, this._typeProperty, this._typeIdVisible, baseType);
        }

        public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
            return this.noTypeInfo(baseType) ? null : new AsPropertyTypeSerializerEx(this._customIdResolver, null, this._typeProperty);
        }

        private boolean noTypeInfo(JavaType baseType) {
            return baseType.isPrimitive() || baseType.isArrayType() || baseType.isCollectionLikeType() || Date.class.isAssignableFrom(baseType.getRawClass());
        }
    }
}

