/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class MiscUtil {
    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static RuntimeException toUnchecked(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static Class<?>[] getParameterTypes(Object ... parameters) {
        int len = parameters == null ? 0 : parameters.length;
        Class[] parameterTypes = new Class[len];
        for (int i = 0; i < len; ++i) {
            parameterTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return parameterTypes;
    }

    public static <T> T castTo(Object value, Class<T> type) {
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public static Class<?> firstAssignable(Class<?> type, Class<?> ... candidates) {
        return MiscUtil.firstAssignable(type, Arrays.asList(candidates));
    }

    public static Class<?> firstAssignable(Class<?> type, Collection<Class<?>> candidates) {
        return candidates.stream().filter(candidate -> candidate.isAssignableFrom(type)).findFirst().orElse(null);
    }

    public static Pattern globToRegex(String glob) {
        StringBuilder sb = new StringBuilder(glob.length()).append('^');
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = glob.toCharArray();
        int last = arr.length - 1;
        block16: for (int i = 0; i <= last; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass != 0) {
                        sb.append('*');
                        continue block16;
                    }
                    if (i < last && arr[i + 1] == '*') {
                        ++i;
                        sb.append("(.*)");
                        continue block16;
                    }
                    sb.append("([^\\\\/]*)");
                    continue block16;
                }
                case '?': {
                    if (inClass != 0) {
                        sb.append('?');
                        continue block16;
                    }
                    sb.append("(.)");
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return Pattern.compile(sb.append('$').toString());
    }

    public static void assertTrue(boolean condition, String message) {
        MiscUtil.assertTrue(condition, () -> message);
    }

    public static void assertTrue(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new IllegalArgumentException(message.get());
        }
    }

    public static void assertState(boolean state, String message) {
        MiscUtil.assertState(state, () -> message);
    }

    public static void assertState(boolean state, Supplier<String> message) {
        if (!state) {
            throw new IllegalStateException(message.get());
        }
    }

    private MiscUtil() {
    }
}

