/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fujion.common.StrUtil;

public class Version
implements Comparable<Version> {
    public static final int NOVAL = -1;
    private final int[] seq = new int[]{-1, -1, -1, -1};
    private final String classifier;

    public Version() {
        this.classifier = null;
    }

    public Version(String value) {
        String classifier = null;
        value = StringUtils.trimToNull((String)value);
        if (value != null) {
            String[] pcs = value.split("\\.", 4);
            for (int i = 0; i < pcs.length; ++i) {
                String pc = pcs[i].trim();
                String string = pc = pc.isEmpty() ? "0" : pc;
                if (classifier != null) {
                    classifier = classifier + "." + pc;
                    continue;
                }
                String vpart = StrUtil.extractIntPrefix(pc);
                pc = StringUtils.substring((String)pc, (int)vpart.length());
                if (!vpart.isEmpty()) {
                    this.setPart(VersionPart.values()[i], Integer.parseInt(vpart));
                }
                if (pc.isEmpty()) continue;
                classifier = (i > 0 && vpart.isEmpty() ? "." : "") + pc;
            }
        }
        this.classifier = classifier;
    }

    public Version(int major) {
        this(major, -1, -1, -1, null);
    }

    public Version(int major, int minor) {
        this(major, minor, -1, -1, null);
    }

    public Version(int major, int minor, int release) {
        this(major, minor, release, -1, null);
    }

    public Version(int major, int minor, int release, int build) {
        this(major, minor, release, build, null);
    }

    public Version(int major, int minor, int release, int build, String classifier) {
        this.setPart(VersionPart.MAJOR, major);
        this.setPart(VersionPart.MINOR, minor);
        this.setPart(VersionPart.RELEASE, release);
        this.setPart(VersionPart.BUILD, build);
        this.classifier = classifier;
    }

    public int getPart(VersionPart part) {
        return this.seq[part.ordinal()];
    }

    public String getClassifier() {
        return this.classifier;
    }

    private void setPart(VersionPart part, int value) {
        this.seq[part.ordinal()] = Math.max(-1, value);
    }

    public VersionPart getSpecificity() {
        int i = ArrayUtils.indexOf((int[])this.seq, (int)-1);
        return i == -1 ? VersionPart.BUILD : (i == 0 ? null : VersionPart.values()[i - 1]);
    }

    public boolean equals(Object v) {
        return v instanceof Version && this.compareTo((Version)v) == 0;
    }

    @Override
    public int compareTo(Version v) {
        return this.compareTo(v, VersionPart.BUILD, true);
    }

    public int compareTo(Version v, boolean includeClassifier) {
        return this.compareTo(v, VersionPart.BUILD, includeClassifier);
    }

    public int compareTo(Version v, VersionPart part) {
        return this.compareTo(v, part, false);
    }

    public int compareTo(Version v, VersionPart part, boolean includeClassifier) {
        int diff = 0;
        int max = part.ordinal();
        for (int i = 0; i <= max && (diff = this.seq[i] - v.seq[i]) == 0; ++i) {
        }
        if (diff == 0 && includeClassifier) {
            diff = ObjectUtils.compare((Comparable)((Object)this.classifier), (Comparable)((Object)v.classifier));
        }
        return diff;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.seq).append((Object)this.classifier).hashCode();
    }

    public String toString(VersionPart part) {
        return this.toString(part, part == null);
    }

    public String toString(VersionPart part, boolean includeClassifier) {
        StringBuilder sb = new StringBuilder();
        int max = part == null ? VersionPart.BUILD.ordinal() : part.ordinal();
        for (int i = 0; i <= max; ++i) {
            int j = this.seq[i];
            if (j < 0) {
                if (part == null) break;
                j = 0;
            }
            sb.append(i == 0 ? "" : ".").append(j);
        }
        if (includeClassifier && this.classifier != null) {
            sb.append(this.classifier);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public static enum VersionPart {
        MAJOR,
        MINOR,
        RELEASE,
        BUILD;

    }
}

