/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.function.Supplier;
import org.fujion.common.StrUtil;

public class Assert {
    public static <T> T fail(String message, Object ... params) {
        throw new IllegalArgumentException(Assert.getMessage(message, params));
    }

    public static <T> T fail(Supplier<String> message, Object ... params) {
        return Assert.fail(message.get(), params);
    }

    public static void isTrue(boolean condition, String message, Object ... params) {
        if (!condition) {
            Assert.fail(message, params);
        }
    }

    public static void isTrue(boolean condition, Supplier<String> message, Object ... params) {
        if (!condition) {
            Assert.fail(message, params);
        }
    }

    public static void isFalse(boolean condition, String message, Object ... params) {
        Assert.isTrue(!condition, message, params);
    }

    public static void isFalse(boolean condition, Supplier<String> message, Object ... params) {
        Assert.isTrue(!condition, message, params);
    }

    public static void isNull(Object value, String message, Object ... params) {
        Assert.isTrue(value == null, message, params);
    }

    public static void isNull(Object value, Supplier<String> message, Object ... params) {
        Assert.isTrue(value == null, message, params);
    }

    public static void notNull(Object value, String message, Object ... params) {
        Assert.isTrue(value != null, message, params);
    }

    public static void notNull(Object value, Supplier<String> message, Object ... params) {
        Assert.isTrue(value != null, message, params);
    }

    public static void state(boolean state, String message, Object ... params) {
        if (!state) {
            throw new IllegalStateException(Assert.getMessage(message, params));
        }
    }

    public static void state(boolean state, Supplier<String> message, Object ... params) {
        if (!state) {
            throw new IllegalStateException(Assert.getMessage(message.get(), params));
        }
    }

    private static String getMessage(String message, Object ... params) {
        return params == null || params.length == 0 ? message : StrUtil.formatMessage(message, params);
    }
}

