/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CyclicIterator<T>
implements Iterator<T> {
    private final Iterable<T> iterable;
    private final boolean hasNext;
    private Iterator<T> iterator;

    public CyclicIterator(Iterable<T> iterable) {
        this.iterable = iterable;
        this.reset();
        this.hasNext = this.iterator != null && this.iterator.hasNext();
    }

    public CyclicIterator(T[] array) {
        this(array == null ? null : Arrays.asList(array));
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        if (!this.iterator.hasNext()) {
            this.reset();
        }
        return this.iterator.next();
    }

    public void reset() {
        this.iterator = this.iterable == null ? null : this.iterable.iterator();
    }
}

