/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Date;
import org.fujion.common.Assert;
import org.fujion.common.DateUtil;

public class DateTimeWrapper
implements Comparable<DateTimeWrapper> {
    private final Temporal temporal;

    public static DateTimeWrapper now() {
        return new DateTimeWrapper(LocalDateTime.now());
    }

    public static DateTimeWrapper today() {
        return new DateTimeWrapper(LocalDate.now());
    }

    public static DateTimeWrapper parse(String value) {
        Date date = DateUtil.parseDate(value);
        Assert.isTrue(date != null, () -> "Unable to parse input '" + value + "'.", new Object[0]);
        return new DateTimeWrapper(date);
    }

    public DateTimeWrapper(LocalDate date) {
        this.temporal = this.validateTemporal(date);
    }

    public DateTimeWrapper(LocalDateTime datetime) {
        this.temporal = this.validateTemporal(datetime);
    }

    public DateTimeWrapper(OffsetDateTime datetime) {
        this.temporal = this.validateTemporal(datetime);
    }

    public DateTimeWrapper(Date date) {
        this.temporal = this.validateTemporal((Temporal)((Object)(DateUtil.hasTime(date) ? DateUtil.toOffsetDateTime(date) : DateUtil.toLocalDate(date))));
    }

    public boolean hasTime() {
        return this.temporal instanceof LocalDateTime || this.temporal instanceof OffsetDateTime;
    }

    public Date getLegacyDate() {
        return DateUtil.toDate(this.temporal);
    }

    public OffsetDateTime getOffsetDateTime() {
        return this.temporal == null ? null : (this.temporal instanceof OffsetDateTime ? (OffsetDateTime)this.temporal : (this.temporal instanceof LocalDateTime ? ((LocalDateTime)this.temporal).atOffset(ZoneOffset.UTC) : ((LocalDate)this.temporal).atStartOfDay().atOffset(ZoneOffset.UTC)));
    }

    public LocalDateTime getDateTime() {
        return this.temporal == null ? null : (this.temporal instanceof LocalDateTime ? (LocalDateTime)this.temporal : (this.temporal instanceof OffsetDateTime ? ((OffsetDateTime)this.temporal).toLocalDateTime() : ((LocalDate)this.temporal).atStartOfDay()));
    }

    public LocalDate getDate() {
        return this.hasTime() ? ((LocalDateTime)this.temporal).toLocalDate() : (LocalDate)this.temporal;
    }

    public LocalTime getTime() {
        return this.hasTime() ? ((LocalDateTime)this.temporal).toLocalTime() : null;
    }

    private Temporal validateTemporal(Temporal temporal) {
        Assert.isTrue(temporal != null, "Date/time value must not be null.", new Object[0]);
        return temporal;
    }

    @Override
    public int compareTo(DateTimeWrapper dtw) {
        if (!this.hasTime() && !dtw.hasTime()) {
            return this.getDate().compareTo(dtw.getDate());
        }
        return this.getDateTime().compareTo(dtw.getDateTime());
    }

    public String toISOString() {
        return this.hasTime() ? DateTimeFormatter.ISO_DATE_TIME.format(this.temporal) : DateTimeFormatter.ISO_DATE.format(this.temporal);
    }

    public String toString() {
        return DateUtil.formatDate(this.temporal);
    }
}

