/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.fujion.common.Logger;

public class Localizer {
    private static final Logger log = Logger.create(Localizer.class);
    private static final List<IMessageSource> messageSources = new ArrayList<IMessageSource>();
    private static ILocaleResolver localeResolver = Locale::getDefault;
    private static ITimeZoneResolver timeZoneResolver = TimeZone::getDefault;

    public static void registerMessageSource(IMessageSource messageSource) {
        messageSources.add(messageSource);
    }

    public static String getMessage(String id, Locale locale, Object ... args) {
        locale = locale == null ? Localizer.getDefaultLocale() : locale;
        for (IMessageSource messageSource : messageSources) {
            try {
                return messageSource.getMessage(id, locale, args).replace("\\\n", "");
            }
            catch (Exception exception) {
            }
        }
        log.warn(() -> "Label not found for identifier: " + id);
        return null;
    }

    public static Locale getDefaultLocale() {
        return localeResolver.getLocale();
    }

    public static void setLocaleResolver(ILocaleResolver localeResolver) {
        Localizer.localeResolver = localeResolver;
    }

    public static TimeZone getTimeZone() {
        return timeZoneResolver.getTimeZone();
    }

    public static void setTimeZoneResolver(ITimeZoneResolver timeZoneResolver) {
        Localizer.timeZoneResolver = timeZoneResolver;
    }

    private Localizer() {
    }

    public static interface ITimeZoneResolver {
        public TimeZone getTimeZone();
    }

    public static interface ILocaleResolver {
        public Locale getLocale();
    }

    public static interface IMessageSource {
        public String getMessage(String var1, Locale var2, Object ... var3);
    }
}

