/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.fujion.common.WeakCollectionBase;

public class WeakMap<K, E>
extends WeakCollectionBase<E>
implements Map<K, E> {
    private final Map<K, WeakReference<E>> referenceMap = new HashMap<K, WeakReference<E>>();

    public WeakMap() {
    }

    public WeakMap(WeakMap<K, E> source) {
        for (Map.Entry<K, E> entry : source.entrySet()) {
            if (entry.getValue() == null) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        this.compact();
        return this.referenceMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.compact();
        return this.referenceMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.compact();
        return this.referenceMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.compact();
        return this.contains(this.referenceMap.values(), value);
    }

    @Override
    public E get(Object key) {
        return this.getReferent(this.referenceMap.get(key));
    }

    @Override
    public E put(K key, E value) {
        return this.getReferent(this.referenceMap.put(key, this.createWeakReference(value)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends E> map) {
        for (Map.Entry<K, E> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        this.compact();
        return new AbstractSet<Map.Entry<K, E>>(){

            @Override
            public Iterator<Map.Entry<K, E>> iterator() {
                return new Iterator<Map.Entry<K, E>>(){
                    final Iterator<Map.Entry<K, WeakReference<E>>> iterator;
                    {
                        this.iterator = WeakMap.this.referenceMap.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, E> next() {
                        final Map.Entry entry = this.iterator.next();
                        return new Map.Entry<K, E>(){

                            @Override
                            public K getKey() {
                                return entry.getKey();
                            }

                            @Override
                            public E getValue() {
                                return WeakMap.this.getReferent((WeakReference)entry.getValue());
                            }

                            @Override
                            public E setValue(E value) {
                                return WeakMap.this.getReferent(entry.setValue(WeakMap.this.createWeakReference(value)));
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return WeakMap.this.referenceMap.size();
            }
        };
    }

    @Override
    public E remove(Object key) {
        return this.getReferent(this.referenceMap.remove(key));
    }

    @Override
    public void clear() {
        this.compact();
        this.referenceMap.clear();
    }

    @Override
    public Set<K> keySet() {
        this.compact();
        return this.referenceMap.keySet();
    }

    @Override
    public Collection<E> values() {
        this.compact();
        return new AbstractCollection<E>(){

            @Override
            public Iterator<E> iterator() {
                return WeakMap.this.getIterator(WeakMap.this.referenceMap.values());
            }

            @Override
            public int size() {
                return WeakMap.this.referenceMap.size();
            }
        };
    }

    @Override
    protected void removeReference(Reference<? extends E> reference) {
        this.referenceMap.values().remove(reference);
    }
}

