/*
 * #%L
 * fujion
 * %%
 * Copyright (C) 2008 - 2016 Regenstrief Institute, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * #L%
 */
package org.fujion.component;

import org.fujion.annotation.Component.PropertyGetter;
import org.fujion.annotation.Component.PropertySetter;

/**
 * Base class for components that allow content to be expressed inline or imported from an external
 * source.
 */
public abstract class BaseSourcedComponent extends BaseComponent {
    
    private String src;
    
    protected BaseSourcedComponent(boolean contentSynced) {
        this(null, contentSynced);
    }
    
    protected BaseSourcedComponent(String content, boolean contentSynced) {
        setContentSynced(contentSynced);
        setContent(content);
    }
    
    @PropertySetter("content")
    @Override
    public void setContent(String content) {
        content = nullify(content);
        
        if (content != null) {
            setSrc(null);
        }
        
        super.setContent(content);
    }

    @PropertyGetter("src")
    public String getSrc() {
        return src;
    }
    
    @PropertySetter(value = "src")
    public void setSrc(String src) {
        src = nullify(src);
        
        if (src != null) {
            super.setContent(null);
        }
        
        if (!areEqual(src, this.src)) {
            this.src = src;

            if (isContentSynced()) {
                sync("src", src);
            }
        }
    }

}
