/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.core;

import java.util.ArrayList;
import java.util.List;
import org.fujion.component.Div;
import org.fujion.event.KeyCode;
import org.junit.Assert;
import org.junit.Test;

public class Tests {
    private static final String ATTR_TEST = "ATTR_TEST";
    private static final String ATTR_OBJECT = "ATTR_OBJECT";
    private static final String ATTR_NULL = "ATTR_NULL";

    @Test
    public void keyCodeTest() {
        Assert.assertEquals((Object)KeyCode.VK_BACK_SPACE, (Object)KeyCode.fromCode((int)8));
        Assert.assertEquals((Object)KeyCode.VK_ASTERISK, (Object)KeyCode.fromString((String)"ASTERISK"));
        Assert.assertEquals((Object)KeyCode.normalizeKeyCapture((String)"^A ~F1 ^@~@^$1"), (Object)"^#65 ~#112 ^@~$#49");
    }

    @Test
    public void attributeTests() {
        Div cmpt = new Div();
        cmpt.setAttribute(ATTR_OBJECT, new Object());
        cmpt.setAttribute(ATTR_TEST, (Object)1234);
        Assert.assertTrue((1234 == (Integer)cmpt.getAttribute(ATTR_TEST, (Object)0) ? 1 : 0) != 0);
        Assert.assertTrue((4321 == (Integer)cmpt.getAttribute(ATTR_OBJECT, (Object)4321) ? 1 : 0) != 0);
        Assert.assertTrue((5678 == (Integer)cmpt.getAttribute(ATTR_NULL, (Object)5678) ? 1 : 0) != 0);
        cmpt.setAttribute(ATTR_TEST, (Object)true);
        Assert.assertTrue((boolean)((Boolean)cmpt.getAttribute(ATTR_TEST, Boolean.class)));
        cmpt.setAttribute(ATTR_TEST, (Object)"TRUE");
        Assert.assertTrue((boolean)((Boolean)cmpt.getAttribute(ATTR_TEST, Boolean.class)));
        cmpt.setAttribute(ATTR_TEST, (Object)"ANYTHING BUT TRUE");
        Assert.assertFalse((boolean)((Boolean)cmpt.getAttribute(ATTR_TEST, Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)cmpt.getAttribute(ATTR_OBJECT, Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)cmpt.getAttribute(ATTR_NULL, Boolean.class)));
        cmpt.setAttribute(ATTR_TEST, (Object)ATTR_TEST);
        Assert.assertEquals((Object)ATTR_TEST, (Object)cmpt.getAttribute(ATTR_TEST, String.class));
        Assert.assertTrue((boolean)((String)cmpt.getAttribute(ATTR_OBJECT, String.class)).contains("Object"));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_NULL, String.class));
        ArrayList list = new ArrayList();
        cmpt.setAttribute(ATTR_TEST, list);
        Assert.assertSame(list, (Object)cmpt.getAttribute(ATTR_TEST, List.class));
        Assert.assertNotNull((Object)cmpt.getAttribute(ATTR_OBJECT));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_NULL));
        cmpt.setAttribute(ATTR_TEST, (Object)cmpt);
        Assert.assertSame((Object)cmpt, (Object)cmpt.getAttribute(ATTR_TEST, Div.class));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_OBJECT, Div.class));
    }
}

