/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.OptionMap;
import org.fujion.common.StrUtil;
import org.fujion.component.BaseComponent;

public class ConvertUtil {
    public static <T> T convert(Object value, Class<T> targetType) {
        return ConvertUtil.convert(value, targetType, null);
    }

    public static <T> T convert(Object value, Class<T> targetType, Object instance) {
        if (targetType == null || targetType.isInstance(value)) {
            return (T)value;
        }
        if (targetType.isEnum()) {
            return (T)ConvertUtil.convertToEnum(value, targetType);
        }
        if (BaseComponent.class.isAssignableFrom(targetType)) {
            return (T)ConvertUtil.convertToComponent(value, targetType, instance);
        }
        return (T)ConvertUtils.convert((Object)value, targetType);
    }

    private static Object convertToEnum(Object value, Class<?> enumType) {
        String val = ConvertUtil.convert(value, String.class, null);
        for (Object e : enumType.getEnumConstants()) {
            if (!((Enum)e).name().equalsIgnoreCase(val)) continue;
            return e;
        }
        throw new IllegalArgumentException(StrUtil.formatMessage((String)"The value \"%s\" is not a member of the enumeration %s", (Object[])new Object[]{value, enumType.getName()}));
    }

    private static BaseComponent convertToComponent(Object value, Class<?> componentType, Object instance) {
        BaseComponent target;
        if (!BaseComponent.class.isInstance(instance)) {
            StrUtil.formatMessage((String)"The property owner is not of the expected type (was %s but expected %s)", (Object[])new Object[]{instance.getClass().getName(), BaseComponent.class.getName()});
        }
        String name = ConvertUtil.convert(value, String.class, instance);
        BaseComponent container = (BaseComponent)instance;
        BaseComponent baseComponent = target = name.startsWith("_fujion_") ? container.getPage().findById(name) : container.findByName(name);
        if (target == null) {
            throw new IllegalArgumentException(StrUtil.formatMessage((String)"A component with name or id \"%s\" was not found", (Object[])new Object[]{name}));
        }
        if (!componentType.isInstance(target)) {
            throw new IllegalArgumentException(StrUtil.formatMessage((String)"The component with name or id \"%s\" is not of the expected type (was %s but expected %s)", (Object[])new Object[]{name, target.getClass().getName(), componentType.getName()}));
        }
        return target;
    }

    public static String convertToJS(String snippet) {
        return snippet == null ? null : (snippet.startsWith("function") ? snippet : "function() {" + snippet + "}");
    }

    public static List<OptionMap> toOptionMaps(Collection<? extends OptionMap.IOptionMapConverter> items) {
        ArrayList<OptionMap> list = new ArrayList<OptionMap>();
        for (OptionMap.IOptionMapConverter iOptionMapConverter : items) {
            list.add(iOptionMapConverter.toMap());
        }
        return list;
    }

    public static void invokeSetter(Object instance, Method setter, Object ... args) {
        try {
            Class<?>[] parameterTypes = setter.getParameterTypes();
            if (args.length != parameterTypes.length) {
                throw new IllegalArgumentException(StrUtil.formatMessage((String)"Attempted to invoke setter method \"%s\" with the incorrect number of arguments (provided %d but expected %d)", (Object[])new Object[]{setter.getName(), args.length, parameterTypes.length}));
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                args[i] = ConvertUtil.convert(args[i], parameterTypes[i], instance);
            }
            setter.invoke(instance, args);
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e, "Exception invoking setter method '%s' on component '%s'", setter.getName(), instance.getClass().getName());
        }
    }

    private ConvertUtil() {
    }
}

