/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Listitem;
import org.fujion.model.IModelAndView;
import org.fujion.model.ISupportsModel;
import org.fujion.model.ModelAndView;

@Component(tag="listbox", widgetClass="Listbox", parentTag={"*"}, childTag={@Component.ChildTag(value="listitem")})
public class Listbox
extends BaseUIComponent
implements ISupportsModel<Listitem> {
    private boolean multiple;
    private int size;
    private final ModelAndView<Listitem, ?> modelAndView = new ModelAndView(this);
    private final Set<Listitem> selected = new LinkedHashSet<Listitem>();

    @Component.PropertyGetter(value="multiple")
    public boolean isMultiple() {
        return this.multiple;
    }

    @Component.PropertySetter(value="multiple")
    public void setMultiple(boolean multiple) {
        if (multiple != this.multiple) {
            if (!multiple && this.selected.size() > 1) {
                this.unselect(null);
            }
            this.multiple = multiple;
            this.sync("multiple", this.multiple);
        }
    }

    @Component.PropertyGetter(value="size")
    public int getSize() {
        return this.size;
    }

    @Component.PropertySetter(value="size")
    public void setSize(int size) {
        if (size != this.size) {
            this.size = size;
            this.sync("size", this.size);
        }
    }

    public Set<Listitem> getSelected() {
        return Collections.unmodifiableSet(this.selected);
    }

    public int getSelectedCount() {
        return this.selected.size();
    }

    public Listitem getSelectedItem() {
        return this.selected.isEmpty() ? null : this.selected.iterator().next();
    }

    public void setSelectedItem(Listitem item) {
        this.validateIsChild(item);
        this.unselect(item);
        if (item != null) {
            item.setSelected(true);
        }
    }

    public int getSelectedIndex() {
        Listitem item = this.getSelectedItem();
        return item == null ? -1 : item.getIndex();
    }

    public void setSelectedIndex(int index) {
        this.setSelectedItem((Listitem)this.getChildAt(index));
    }

    protected void _updateSelected(Listitem item) {
        if (item.isSelected() != this.selected.contains(item)) {
            if (!this.multiple) {
                this.unselect(null);
            }
            if (item.isSelected()) {
                this.selected.add(item);
            } else {
                this.selected.remove(item);
            }
        }
    }

    public void clearSelected() {
        this.unselect(null);
    }

    private void unselect(Listitem skip) {
        for (Listitem item : this.selected) {
            if (item == skip) continue;
            item._setSelected(false, true, false);
        }
        this.selected.clear();
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        this._updateSelected((Listitem)child);
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        if (this.selected.remove(child)) {
            ((Listitem)child)._setSelected(false, true, false);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.modelAndView.destroy();
    }

    @Override
    public IModelAndView<Listitem, ?> getModelAndView() {
        return this.modelAndView;
    }
}

