/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.function.BooleanSupplier;
import org.fujion.ancillary.INamespace;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.client.ExecutionContext;
import org.fujion.component.BaseUIComponent;
import org.fujion.event.Event;
import org.fujion.event.IEventListener;

@Component(tag="window", widgetClass="Window", content=Component.ContentHandling.AS_CHILD, parentTag={"*"}, childTag={@Component.ChildTag(value="*")})
public class Window
extends BaseUIComponent
implements INamespace {
    private String title;
    private String image;
    private Position position = Position.CENTER;
    private boolean closable;
    private boolean movable = true;
    private boolean sizable;
    private boolean maximizable;
    private boolean minimizable;
    private Size size = Size.NORMAL;
    private BooleanSupplier onCanClose;
    private CloseAction closeAction = CloseAction.DESTROY;
    private Mode mode;
    private IEventListener closeListener;

    public Window() {
        this.setMode(Mode.INLINE);
        this.addClass("flavor:panel-default");
    }

    @Component.PropertyGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @Component.PropertySetter(value="title")
    public void setTitle(String title) {
        if (!this.areEqual(title, this.title)) {
            this.title = title;
            this.sync("title", this.title);
        }
    }

    @Component.PropertyGetter(value="image")
    public String getImage() {
        return this.image;
    }

    @Component.PropertySetter(value="image")
    public void setImage(String image) {
        if (!this.areEqual(image = this.nullify(image), this.image)) {
            this.image = image;
            this.sync("image", this.image);
        }
    }

    @Component.PropertyGetter(value="closable")
    public boolean isClosable() {
        return this.closable;
    }

    @Component.PropertySetter(value="closable")
    public void setClosable(boolean closable) {
        if (closable != this.closable) {
            this.closable = closable;
            this.sync("closable", this.closable);
        }
    }

    @Component.PropertyGetter(value="sizable")
    public boolean isSizable() {
        return this.sizable;
    }

    @Component.PropertySetter(value="sizable")
    public void setSizable(boolean sizable) {
        if (sizable != this.sizable) {
            this.sizable = sizable;
            this.sync("sizable", this.sizable);
        }
    }

    @Component.PropertyGetter(value="position")
    public Position getPosition() {
        return this.position;
    }

    @Component.PropertySetter(value="position")
    public void setPosition(Position position) {
        if (position != this.position) {
            this.position = position;
            this.sync("position", (Object)this.position);
        }
    }

    @Component.PropertyGetter(value="movable")
    public boolean isMovable() {
        return this.movable;
    }

    @Component.PropertySetter(value="movable")
    public void setMovable(boolean movable) {
        if (movable != this.movable) {
            this.movable = movable;
            this.sync("movable", this.movable);
        }
    }

    @Component.PropertyGetter(value="maximizable")
    public boolean isMaximizable() {
        return this.maximizable;
    }

    @Component.PropertySetter(value="maximizable")
    public void setMaximizable(boolean maximizable) {
        if (maximizable != this.maximizable) {
            this.maximizable = maximizable;
            this.sync("maximizable", this.maximizable);
        }
    }

    @Component.PropertyGetter(value="minimizable")
    public boolean isMinimizable() {
        return this.minimizable;
    }

    @Component.PropertySetter(value="minimizable")
    public void setMinimizable(boolean minimizable) {
        if (minimizable != this.minimizable) {
            this.minimizable = minimizable;
            this.sync("minimizable", this.minimizable);
        }
    }

    @Component.PropertyGetter(value="mode")
    public Mode getMode() {
        return this.mode;
    }

    @Component.PropertySetter(value="mode")
    public void setMode(Mode mode) {
        Mode mode2 = mode = mode == null ? Mode.INLINE : mode;
        if (mode != this.mode) {
            this.mode = mode;
            this.sync("mode", (Object)this.mode);
        }
    }

    @Component.PropertyGetter(value="size")
    public Size getSize() {
        return this.size;
    }

    @Component.PropertySetter(value="size")
    public void setSize(Size size) {
        Size size2 = size = size == null ? Size.NORMAL : size;
        if (size != this.size) {
            this.size = size;
            this.sync("size", (Object)this.size);
        }
    }

    @Component.PropertyGetter(value="closeAction")
    public CloseAction getCloseAction() {
        return this.closeAction;
    }

    @Component.PropertySetter(value="closeAction")
    public void setCloseAction(CloseAction closeAction) {
        this.closeAction = closeAction == null ? CloseAction.DESTROY : closeAction;
    }

    private boolean canClose() {
        return this.onCanClose == null || this.onCanClose.getAsBoolean();
    }

    public void close() {
        if (this.canClose()) {
            switch (this.closeAction) {
                case DESTROY: {
                    this.destroy();
                    break;
                }
                case DETACH: {
                    this.detach();
                    break;
                }
                case HIDE: {
                    this.setVisible(false);
                }
            }
            if (this.closeListener != null) {
                try {
                    this.closeListener.onEvent(new Event("close", this));
                }
                finally {
                    this.closeListener = null;
                }
            }
        }
    }

    public BooleanSupplier getOnCanClose() {
        return this.onCanClose;
    }

    public void setOnCanClose(BooleanSupplier onCanClose) {
        this.onCanClose = onCanClose;
    }

    public void modal(IEventListener closeListener) {
        this.doShow(Mode.MODAL, closeListener);
    }

    public void popup(IEventListener closeListener) {
        this.doShow(Mode.POPUP, closeListener);
    }

    private void doShow(Mode mode, IEventListener closeListener) {
        if (this.closeListener != null) {
            throw new IllegalStateException("Window is already open.");
        }
        if (this.getParent() == null) {
            this.setParent(ExecutionContext.getPage());
        }
        this.closeListener = closeListener;
        this.setMode(mode);
        this.setVisible(true);
        this.fireEvent("open");
    }

    @EventHandler(value={"close"}, syncToClient=false)
    private void _close(Event event) {
        this.close();
    }

    public static enum Position {
        CENTER,
        LEFT_CENTER,
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_CENTER,
        RIGHT_TOP,
        RIGHT_BOTTOM,
        CENTER_TOP,
        CENTER_BOTTOM;

    }

    public static enum CloseAction {
        DETACH,
        DESTROY,
        HIDE;

    }

    public static enum Size {
        NORMAL,
        MAXIMIZED,
        MINIMIZED;

    }

    public static enum Mode {
        MODAL,
        INLINE,
        POPUP;

    }
}

