/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.event;

import org.fujion.annotation.EventType;
import org.fujion.annotation.OnFailure;
import org.fujion.client.ExecutionContext;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;

public class Event {
    @EventType.EventParameter(onFailure=OnFailure.EXCEPTION)
    private String type;
    @EventType.EventParameter(onFailure=OnFailure.IGNORE)
    private BaseComponent target;
    @EventType.EventParameter(value="target", onFailure=OnFailure.IGNORE)
    private String targetId;
    @EventType.EventParameter(onFailure=OnFailure.IGNORE)
    private BaseComponent currentTarget;
    @EventType.EventParameter(onFailure=OnFailure.IGNORE)
    private BaseComponent relatedTarget;
    @EventType.EventParameter(onFailure=OnFailure.IGNORE)
    private Object data;
    @EventType.EventParameter
    private Page page;
    private boolean stopPropagation;

    public Event() {
    }

    public Event(String type) {
        this(type, null, null);
    }

    public Event(String type, BaseComponent target) {
        this(type, target, null);
    }

    public Event(String type, BaseComponent target, Object data) {
        this(type, target, null, data);
    }

    public Event(String type, BaseComponent target, BaseComponent relatedTarget) {
        this(type, target, relatedTarget, null);
    }

    public Event(String type, BaseComponent target, BaseComponent relatedTarget, Object data) {
        this.type = type;
        this.target = target;
        this.targetId = target == null ? null : target.getId();
        this.data = data;
        this.currentTarget = target;
        this.relatedTarget = relatedTarget;
        this.page = target != null ? target.getPage() : null;
        this.page = this.page == null ? ExecutionContext.getPage() : this.page;
    }

    public Event(Event source) {
        this(source.type, source);
    }

    public Event(String type, Event source) {
        this.type = type;
        this.target = source.target;
        this.targetId = source.targetId;
        this.data = source.data;
        this.currentTarget = source.currentTarget;
        this.relatedTarget = source.relatedTarget;
        this.page = source.page;
    }

    public Page getPage() {
        return this.page;
    }

    public String getType() {
        return this.type;
    }

    public BaseComponent getTarget() {
        return this.target != null ? this.target : (this.currentTarget != null ? this.currentTarget : this.page);
    }

    public BaseComponent getCurrentTarget() {
        return this.currentTarget != null ? this.currentTarget : (this.target != null ? this.target : this.page);
    }

    public BaseComponent getRelatedTarget() {
        return this.relatedTarget;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Object getData() {
        return this.data;
    }

    public void stopPropagation() {
        this.stopPropagation = true;
    }

    public boolean isStopped() {
        return this.stopPropagation;
    }
}

