/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.expression;

import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class MessageAccessor
implements PropertyAccessor {
    private static final Class<?>[] TARGET_CLASSES = new Class[]{MessageSource.class, MessageContext.class};

    public Class<?>[] getSpecificTargetClasses() {
        return TARGET_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        MessageContext result = null;
        if (target instanceof MessageSource) {
            result = new MessageContext((MessageSource)target, name);
        } else if (target instanceof MessageContext) {
            result = ((MessageContext)target).addName(name);
        }
        return result == null ? null : new TypedValue((Object)result);
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException("Message source is read-only.");
    }

    private static class MessageContext {
        private String name;
        private final MessageSource messageSource;

        MessageContext(MessageSource messageSource, String name) {
            this.messageSource = messageSource;
            this.name = name;
        }

        MessageContext addName(String name) {
            this.name = this.name + "." + name;
            return this;
        }

        public String toString() {
            String message = this.getMessage(this.name);
            int i = 0;
            int k = 0;
            while ((i = message.indexOf("${")) > -1 && k++ < 20) {
                int j = message.indexOf("}", i);
                String repl = this.getMessage(message.substring(i + 2, j));
                message = message.substring(0, i) + repl + message.substring(j + 1);
            }
            return message;
        }

        private String getMessage(String name) {
            try {
                return this.messageSource.getMessage(name, null, LocaleContextHolder.getLocale());
            }
            catch (NoSuchMessageException e) {
                return "";
            }
        }
    }

    public static class MessageContextConverter
    implements Converter<MessageContext, String> {
        public String convert(MessageContext source) {
            return source.toString();
        }
    }
}

