/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.taglib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.common.AbstractRegistry;
import org.fujion.common.MiscUtil;
import org.fujion.taglib.TagLibrary;
import org.fujion.taglib.TagLibraryParser;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class TagLibraryRegistry
extends AbstractRegistry<String, TagLibrary>
implements ApplicationContextAware {
    private static Log log = LogFactory.getLog(TagLibraryRegistry.class);
    private static TagLibraryRegistry instance = new TagLibraryRegistry();

    public static TagLibraryRegistry getInstance() {
        return instance;
    }

    private TagLibraryRegistry() {
    }

    protected String getKey(TagLibrary item) {
        return item.getUri();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            Resource[] resources;
            for (Resource resource : resources = applicationContext.getResources("classpath*:**/*.tld")) {
                log.info((Object)("Found tag library at " + resource));
                try {
                    this.register(TagLibraryParser.getInstance().parse(resource));
                }
                catch (Exception e) {
                    log.error((Object)"Error parsing tag library", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }
}

