/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.annotation.Annotation;
import org.fujion.common.MiscUtil;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractClassScanner<T, A extends Annotation> {
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private final Class<T> targetClass;
    private final Class<? extends Annotation> annotationClass;

    public AbstractClassScanner(Class<T> targetClass, Class<? extends Annotation> annotationClass) {
        this.targetClass = targetClass;
        this.annotationClass = annotationClass;
    }

    public void scanPackage(Package pkg) {
        this.scanPackage(pkg.getName());
    }

    public void scanPackage(String pkgName) {
        try {
            for (Resource resource : this.resolver.getResources("classpath*:" + pkgName.replace(".", "/") + "/*.class")) {
                String path = resource.getURL().getPath();
                int i = path.lastIndexOf(".jar!/") + 6;
                i = i > 5 ? i : path.lastIndexOf("/classes/") + 9;
                int j = path.lastIndexOf(".class");
                path = path.substring(i, j).replace("/", ".");
                Class<?> clazz = Class.forName(path);
                this.scanClass(clazz);
            }
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public void scanClass(String className) {
        try {
            this.scanClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public void scanClass(Class<?> clazz) {
        for (Class<?> innerClass : clazz.getDeclaredClasses()) {
            this.scanClass(innerClass);
        }
        if (!clazz.isAnnotationPresent(this.annotationClass)) {
            return;
        }
        if (!this.targetClass.isAssignableFrom(clazz)) {
            throw new RuntimeException(this.annotationClass.getName() + " annotation only valid on " + this.targetClass.getName() + " subclass.");
        }
        this.doScanClass(clazz);
    }

    protected abstract void doScanClass(Class<T> var1);
}

