/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.theme;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.client.WebJarLocator;
import org.fujion.common.AbstractRegistry;
import org.fujion.common.MiscUtil;
import org.fujion.theme.Theme;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class ThemeRegistry
extends AbstractRegistry<String, Theme>
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(ThemeRegistry.class);
    private static final ThemeRegistry instance = new ThemeRegistry();

    public static ThemeRegistry getInstance() {
        return instance;
    }

    protected String getKey(Theme theme) {
        return theme.getName();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.loadThemes(applicationContext, "classpath*:META-INF");
        this.loadThemes(applicationContext, "WEB-INF");
    }

    private void loadThemes(ApplicationContext applicationContext, String path) {
        try {
            for (Resource resource : applicationContext.getResources(path + "/theme.properties")) {
                try (InputStream in2 = resource.getInputStream();){
                    Properties props = new Properties();
                    props.load(in2);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String key = entry.getKey().toString();
                        String value = entry.getValue().toString();
                        this.updateTheme(key, value);
                    }
                }
                catch (FileNotFoundException in2) {
                }
                catch (Exception e) {
                    log.error((Object)("Error reading theme configuration data from " + resource), (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private Theme getOrCreateTheme(String themeName) {
        Theme theme = (Theme)this.get(themeName);
        if (theme == null) {
            theme = new Theme(themeName, WebJarLocator.getInstance().getConfig());
            this.register(theme);
            log.info((Object)("Registered theme: " + themeName));
        }
        return theme;
    }

    private void updateTheme(String configPath, String value) {
        ObjectNode config;
        String[] path = configPath.split("\\/");
        Theme theme = this.getOrCreateTheme(path[0]);
        ObjectNode node = config = theme.getConfig();
        int last = path.length - 1;
        value = StringUtils.trimToNull((String)value);
        for (int i = 1; i <= last; ++i) {
            String pnode = path[i];
            ObjectNode parent = node;
            if (i == last) {
                if (value == null) {
                    parent.remove(pnode);
                    break;
                }
                parent.set(pnode, (JsonNode)new TextNode(value));
                break;
            }
            node = (ObjectNode)parent.get(pnode);
            if (node != null) continue;
            if (value == null) {
                return;
            }
            node = config.objectNode();
            parent.set(pnode, (JsonNode)node);
        }
    }
}

