/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class CssStyles {
    private final Map<String, String> styles = new LinkedHashMap<String, String>();

    public void parse(String value, boolean clear) {
        if (clear) {
            this.styles.clear();
        }
        if (StringUtils.isEmpty((Object)value)) {
            return;
        }
        for (String style : value.split("\\;")) {
            String[] pcs = style.split("\\:", 2);
            String name = pcs[0].trim();
            String string = value = pcs.length == 1 ? "" : pcs[1].trim();
            if (value.isEmpty()) {
                this.styles.remove(name);
                continue;
            }
            this.styles.put(name, value);
        }
    }

    public Map<String, String> get() {
        return Collections.unmodifiableMap(this.styles);
    }

    public String get(String style) {
        return this.styles.get(style);
    }

    public String put(String style, String value) {
        return value == null ? this.remove(style) : this.styles.put(style, value);
    }

    public String remove(String style) {
        return this.styles.remove(style);
    }

    public boolean isEmpty() {
        return this.styles.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.styles.entrySet()) {
            if (entry.getValue() == null) continue;
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(entry.getKey()).append(':').append(entry.getValue());
        }
        return sb.toString();
    }
}

