/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.annotation.ComponentScanner;
import org.fujion.common.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaGenerator {
    private final Document schema;
    private static final String NS_FUJION = "http://www.fujion.org/schema/fsp";
    private static final String NS_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String NS_VERSIONING = "http://www.w3.org/2007/XMLSchema-versioning";
    private static final String[] DEFAULT_PACKAGES = new String[]{"org.fujion.component"};

    public static void main(String ... args) throws Exception {
        String output;
        Options options = new Options();
        Option option = new Option("p", "package", true, "Java package(s) to scan (default: " + DEFAULT_PACKAGES[0] + ")");
        option.setArgs(-2);
        options.addOption(option);
        option = new Option("v", false, "Schema v1.0 compatible (default: v1.1 compatible)");
        options.addOption(option);
        option = new Option("h", "help", false, "This help message");
        options.addOption(option);
        CommandLine cmd = new DefaultParser().parse(options, args);
        if (cmd.hasOption("h")) {
            new HelpFormatter().printHelp("SchemaGenerator [options] ...", options);
            return;
        }
        String[] packages = cmd.hasOption("p") ? cmd.getOptionValues("p") : DEFAULT_PACKAGES;
        String xml = new SchemaGenerator(packages, cmd.hasOption("v")).toString();
        String string = output = cmd.getArgs().length == 0 ? null : cmd.getArgs()[0];
        if (output == null) {
            System.out.println(xml);
        } else {
            try (FileOutputStream strm = new FileOutputStream(output);){
                IOUtils.write((String)xml, (OutputStream)strm, (Charset)StandardCharsets.UTF_8);
            }
        }
    }

    public SchemaGenerator(String[] packages, boolean v1_0_compatible) throws Exception {
        ComponentRegistry registry = ComponentRegistry.getInstance();
        for (String pkg : packages) {
            ComponentScanner.getInstance().scanPackage(pkg);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.schema = docBuilder.newDocument();
        Element root = this.schema.createElementNS(NS_SCHEMA, "xs:schema");
        root.setAttribute("targetNamespace", NS_FUJION);
        root.setAttribute("xmlns:fsp", NS_FUJION);
        root.setAttributeNS(NS_VERSIONING, "vc:minVersion", v1_0_compatible ? "1.0" : "1.1");
        root.setAttribute("elementFormDefault", "qualified");
        this.schema.appendChild(root);
        Iterator iterator = registry.iterator();
        while (iterator.hasNext()) {
            boolean contentAllowed;
            ComponentDefinition def = (ComponentDefinition)iterator.next();
            if (def.getTag().startsWith("#")) continue;
            Element ele = this.createElement("element", root, "name", def.getTag());
            Element ct = this.createElement("complexType", ele);
            boolean childrenAllowed = def.childrenAllowed();
            boolean bl = contentAllowed = def.contentHandling() != Component.ContentHandling.ERROR;
            if (!childrenAllowed && contentAllowed) {
                Element sc = this.createElement("simpleContent", ct);
                ct = this.createElement("extension", sc);
                ct.setAttribute("base", "xs:string");
            } else if (childrenAllowed) {
                Element childAnchor;
                if (contentAllowed) {
                    ct.setAttribute("mixed", "true");
                }
                if (v1_0_compatible) {
                    childAnchor = this.createElement("choice", ct);
                    childAnchor.setAttribute("minOccurs", "0");
                    childAnchor.setAttribute("maxOccurs", "unbounded");
                } else {
                    childAnchor = this.createElement("all", ct);
                }
                for (Map.Entry<String, ComponentDefinition.Cardinality> childTag : def.getChildTags().entrySet()) {
                    String tag = childTag.getKey();
                    ComponentDefinition.Cardinality card = childTag.getValue();
                    if (!"*".equals(tag)) {
                        ComponentDefinition childDef = (ComponentDefinition)registry.get(tag);
                        this.addChildElement(childAnchor, childDef, def, card);
                        continue;
                    }
                    Iterator iterator2 = registry.iterator();
                    while (iterator2.hasNext()) {
                        ComponentDefinition childDef = (ComponentDefinition)iterator2.next();
                        this.addChildElement(childAnchor, childDef, def, card);
                    }
                }
            }
            this.processAttributes(def.getSetters(), ct);
            this.processAttributes(def.getFactoryParameters(), ct);
        }
    }

    public String toString() {
        return XMLUtil.toString((Document)this.schema);
    }

    private void processAttributes(Map<String, Method> setters, Element ct) {
        for (Map.Entry<String, Method> setter : setters.entrySet()) {
            if (setter.getKey().startsWith("#")) continue;
            Element attr = this.createElement("attribute", ct, "name", setter.getKey());
            Class<?> javaType = setter.getValue().getParameterTypes()[0];
            if (javaType.isEnum()) {
                this.processEnum(attr, javaType);
                continue;
            }
            attr.setAttribute("type", this.getType(javaType));
        }
    }

    private void addChildElement(Element seq, ComponentDefinition childDef, ComponentDefinition parentDef, ComponentDefinition.Cardinality card) {
        if (childDef.getTag().startsWith("#")) {
            return;
        }
        if (childDef != null && !childDef.isParentTag(parentDef.getTag())) {
            return;
        }
        Element child = this.createElement("element", seq, "ref", "fsp:" + childDef.getTag());
        child.setAttribute("minOccurs", Integer.toString(card.getMinimum()));
        if (card.hasMaximum()) {
            child.setAttribute("maxOccurs", Integer.toString(card.getMaximum()));
        } else {
            child.setAttribute("maxOccurs", "unbounded");
        }
    }

    private void processEnum(Element attr, Class<?> javaType) {
        Element st = this.createElement("simpleType", attr);
        Element res = this.createElement("restriction", st);
        res.setAttribute("base", "xs:string");
        for (Object val : javaType.getEnumConstants()) {
            this.createElement("enumeration", res, "value", val.toString().toLowerCase());
        }
    }

    private String getType(Class<?> javaType) {
        String type = null;
        type = type != null ? type : this.getType(javaType, "xs:boolean", Boolean.TYPE, Boolean.class);
        type = type != null ? type : this.getType(javaType, "xs:integer", Integer.TYPE, Integer.class);
        type = type != null ? type : this.getType(javaType, "xs:decimal", Float.TYPE, Float.class, Double.TYPE, Double.class);
        return type != null ? type : "xs:string";
    }

    private String getType(Class<?> javaType, String type, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(javaType)) continue;
            return type;
        }
        return null;
    }

    private Element createElement(String tag, Element parent) {
        return this.createElement(tag, parent, null, null);
    }

    private Element createElement(String tag, Element parent, String keyName, String keyValue) {
        Element element = this.schema.createElement("xs:" + tag);
        if (keyName != null) {
            NodeList nodes = parent.getChildNodes();
            element.setAttribute(keyName, keyValue);
            int j = nodes.getLength();
            for (int i = 0; i < j; ++i) {
                Element sib = (Element)nodes.item(i);
                String val = sib.getAttribute(keyName);
                if (val == null || val.compareToIgnoreCase(keyValue) < 0) continue;
                parent.insertBefore(element, sib);
                return element;
            }
        }
        parent.appendChild(element);
        return element;
    }
}

