/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.component.Popup;
import org.fujion.component.Textbox;
import org.fujion.event.CloseEvent;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;
import org.fujion.event.OpenEvent;

@Component(tag="popupbox", widgetClass="Popupbox", parentTag={"*"}, childTag={@Component.ChildTag(value="popup", maximum=1)})
public class Popupbox
extends Textbox {
    private boolean open;

    public void open() {
        this.setOpen(true);
    }

    public void close() {
        this.setOpen(false);
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        super.afterAddChild(child);
        if (this.getPage() != null) {
            this.setPopup((Popup)child);
        }
    }

    @Override
    protected void onAttach(Page page) {
        super.onAttach(page);
        if (this.getChildCount() > 0) {
            this.setPopup((Popup)this.getFirstChild());
        }
    }

    @Override
    public void setPopup(Popup popup) {
        BaseComponent child = this.getFirstChild();
        if (child != null && child != popup) {
            throw new IllegalArgumentException("You may not set a popup reference when a child popup is present.");
        }
        if (popup != this.getPopup()) {
            this.open = false;
        }
        super.setPopup(popup);
    }

    @Component.PropertyGetter(value="open")
    public boolean isOpen() {
        return this.open;
    }

    @Component.PropertySetter(value="open")
    public void setOpen(boolean open) {
        if (open != this.open) {
            this.open = open;
            this.invoke(this.open ? "open" : "close", new Object[0]);
        }
    }

    @EventHandler(value={"popupopen", "popupclose"})
    private void _onOpen(Event event) {
        boolean open = "popupopen".equals(event.getType());
        if (open != this.open) {
            this.open = open;
            event = open ? new OpenEvent(this, event.getData()) : new CloseEvent(this, event.getData());
            EventUtil.send(event);
        }
    }
}

