/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseScriptComponent;
import org.fujion.component.Page;
import org.fujion.core.WebUtil;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;
import org.fujion.script.IScriptLanguage;
import org.fujion.script.ScriptRegistry;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

@Component(tag="sscript", widgetClass="MetaWidget", content=Component.ContentHandling.AS_ATTRIBUTE, parentTag={"*"})
public class ServerScript
extends BaseScriptComponent {
    private static final String EVENT_DEFERRED = "deferredExecution";
    public static final String EVENT_EXECUTED = "scriptExecution";
    private IScriptLanguage script;

    public ServerScript() {
        super(false);
    }

    public ServerScript(String script) {
        super(script, false);
    }

    @Override
    protected void onAttach(Page page) {
        super.onAttach(page);
        if (this.getDefer()) {
            EventUtil.post(EVENT_DEFERRED, this, null);
        } else {
            this.doExecute();
        }
    }

    private Object execute() {
        Assert.notNull((Object)this.script, (String)"A script type must be specified");
        return this.script.parse(this.getScript()).run(Collections.singletonMap(this.script.getSelf(), this));
    }

    private String getScript() {
        if (this.getSrc() != null) {
            return this.getExternalScript();
        }
        return this.getContent();
    }

    private String getExternalScript() {
        try {
            Resource resource = WebUtil.getResource(this.getSrc());
            return IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    @Override
    @Component.PropertySetter(value="type")
    public void setType(String type) {
        IScriptLanguage iScriptLanguage = this.script = (type = this.nullify(type)) == null ? null : (IScriptLanguage)ScriptRegistry.getInstance().get(type);
        if (this.script == null && type != null) {
            throw new IllegalArgumentException("Unknown script type: " + type);
        }
        super.setType(type);
    }

    @EventHandler(value={"deferredExecution"}, syncToClient=false)
    private void onDeferredExecution() {
        this.doExecute();
    }

    private void doExecute() {
        EventUtil.post(new Event(EVENT_EXECUTED, (BaseComponent)this, this.execute()));
    }
}

