/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.List;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.Template;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageParser;
import org.springframework.util.Assert;

@Component(tag="snippet", widgetClass="MetaWidget", parentTag={"template"})
public class Snippet
extends BaseComponent {
    private String src;
    private String anchor;
    private AnchorPosition position = AnchorPosition.CHILD;

    void materialize(Template template) {
        Assert.isTrue((this.src != null && this.anchor != null ? 1 : 0) != 0, (String)"A snippet requires both a src and an anchor");
        BaseComponent ref = template.findByName(this.anchor);
        Assert.notNull((Object)ref, (String)("Could not locate anchor for snippet at " + this.anchor));
        PageDefinition def = PageParser.getInstance().parse(this.src);
        BaseComponent parent = ref.getParent();
        int index = ref.getIndex();
        switch (this.position) {
            case CHILD: {
                this.addToParent(ref, -1, def);
                break;
            }
            case PARENT: {
                ref.detach();
                BaseComponent newParent = this.addToParent(parent, index, def).get(0);
                ref.setParent(newParent);
                break;
            }
            case REPLACE: {
                ref.destroy();
                this.addToParent(parent, index, def);
                break;
            }
            case BEFORE: {
                this.addToParent(parent, index, def);
                break;
            }
            case AFTER: {
                this.addToParent(parent, index + 1, def);
            }
        }
    }

    private List<BaseComponent> addToParent(BaseComponent parent, int index, PageDefinition def) {
        Assert.notNull((Object)parent, (String)("Anchor must have a parent for position value of " + (Object)((Object)this.position)));
        List<BaseComponent> children = def.materialize(null);
        for (BaseComponent child : children) {
            parent.addChild(child, index);
            index = index < 0 ? index : index + 1;
        }
        return children;
    }

    @Component.PropertySetter(value="src")
    private void setSrc(String src) {
        this.src = this.trimify(src);
    }

    @Component.PropertySetter(value="anchor")
    private void setAnchor(String anchor) {
        this.anchor = this.trimify(anchor);
    }

    @Component.PropertySetter(value="position")
    private void setPosition(AnchorPosition position) {
        this.position = position == null ? AnchorPosition.CHILD : position;
    }

    private static enum AnchorPosition {
        BEFORE,
        AFTER,
        CHILD,
        PARENT,
        REPLACE;

    }
}

