/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Iterator;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Treenode;
import org.fujion.model.IModelAndView;
import org.fujion.model.ISupportsModel;
import org.fujion.model.ModelAndView;

@Component(tag="treeview", widgetModule="fujion-treeview", widgetClass="Treeview", parentTag={"*"}, childTag={@Component.ChildTag(value="treenode")})
public class Treeview
extends BaseUIComponent
implements Iterable<Treenode>,
ISupportsModel<Treenode> {
    private boolean showRoot;
    private boolean showLines = true;
    private boolean showToggles = true;
    private Treenode selectedNode;
    private final ModelAndView<Treenode, Object> modelAndView = new ModelAndView(this);

    @Component.PropertyGetter(value="showRoot")
    public boolean getShowRoot() {
        return this.showRoot;
    }

    @Component.PropertySetter(value="showRoot")
    public void setShowRoot(boolean showRoot) {
        if (showRoot != this.showRoot) {
            this.showRoot = showRoot;
            this.sync("showRoot", this.showRoot);
        }
    }

    @Component.PropertyGetter(value="showLines")
    public boolean getShowLines() {
        return this.showLines;
    }

    @Component.PropertySetter(value="showLines")
    public void setShowLines(boolean showLines) {
        if (showLines != this.showLines) {
            this.showLines = showLines;
            this.sync("showLines", this.showLines);
        }
    }

    @Component.PropertyGetter(value="showToggles")
    public boolean getShowToggles() {
        return this.showToggles;
    }

    @Component.PropertySetter(value="showToggles")
    public void setShowToggles(boolean showToggles) {
        if (showToggles != this.showToggles) {
            this.showToggles = showToggles;
            this.sync("showToggles", this.showToggles);
        }
    }

    public void collapseAll() {
        this.expandOrCollapse(this, true);
    }

    public void expandAll() {
        this.expandOrCollapse(this, false);
    }

    private void expandOrCollapse(BaseComponent parent, boolean collapse) {
        for (BaseComponent child : parent.getChildren()) {
            ((Treenode)child).setCollapsed(collapse);
            this.expandOrCollapse(child, collapse);
        }
    }

    public Treenode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Treenode selectedNode) {
        if (selectedNode == this.selectedNode) {
            return;
        }
        if (this.selectedNode != null) {
            this.selectedNode._setSelected(false, true, false);
        }
        this.selectedNode = selectedNode;
        if (selectedNode != null) {
            selectedNode._setSelected(true, true, false);
        }
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        if (child.isAncestor(this.selectedNode)) {
            this.selectedNode = null;
        }
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        Treenode selnode = this.findSelected((Treenode)child, null);
        if (selnode != null) {
            this.setSelectedNode(selnode);
        }
    }

    private Treenode findSelected(Treenode node, Treenode selnode) {
        if (node.isSelected()) {
            if (selnode != null) {
                selnode._setSelected(false, true, false);
            }
            selnode = node;
        }
        for (BaseComponent child : node.getChildren()) {
            selnode = this.findSelected((Treenode)child, selnode);
        }
        return selnode;
    }

    @Override
    public Iterator<Treenode> iterator() {
        return new Treenode.TreenodeIterator(this);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.modelAndView.destroy();
    }

    @Override
    public IModelAndView<Treenode, ?> getModelAndView() {
        return this.modelAndView;
    }
}

