/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.core;

import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil {
    private static Log log = LogFactory.getLog(RequestUtil.class);

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttrs == null ? null : requestAttrs.getRequest();
    }

    public static HttpSession getSession() {
        return RequestUtil.getSession((ServletRequest)RequestUtil.getRequest());
    }

    public static HttpSession getSession(ServletRequest request) {
        return request instanceof HttpServletRequest ? ((HttpServletRequest)request).getSession(false) : null;
    }

    public static void logHeaderNames() {
        HttpServletRequest request = RequestUtil.getRequest();
        if (request == null) {
            log.debug((Object)"logHeaderNames() invoked outside the scope of a servlet request");
        } else {
            Enumeration enumeration = request.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String headerName = (String)enumeration.nextElement();
                log.trace((Object)String.format("HeaderName: %s", headerName));
            }
        }
    }

    public static String getServerName() {
        HttpServletRequest request = RequestUtil.getRequest();
        return request == null ? null : request.getServerName();
    }

    public static String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            log.debug((Object)"Exception occurred obtaining localhost IP address", (Throwable)e);
            return null;
        }
    }

    public static String getRemoteAddress() {
        HttpServletRequest request = RequestUtil.getRequest();
        String ipAddress = null;
        if (request != null) {
            ipAddress = request.getHeader("x-forwarded-for");
            boolean ipFromHeader = true;
            if (RequestUtil.isEmpty(ipAddress)) {
                ipAddress = request.getHeader("X_FORWARDED_FOR");
                if (RequestUtil.isEmpty(ipAddress)) {
                    ipFromHeader = false;
                    ipAddress = request.getRemoteAddr();
                }
                RequestUtil.logHeaderNames();
            }
            if (log.isTraceEnabled()) {
                RequestUtil.logHeaderNames();
                log.trace((Object)String.format("Remote address: %s , obtained from X-FORWARDED_FOR header?", ipAddress, ipFromHeader));
            }
        }
        return ipAddress;
    }

    public static String getBaseURL(HttpServletRequest request) {
        return "http" + (request.isSecure() ? "s" : "") + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
    }

    public static URL getResourceURL(HttpServletRequest request) {
        return RequestUtil.getResourceURL(request.getPathInfo());
    }

    public static URL getResourceURL(String path) {
        try {
            return ResourceUtils.getURL((String)(path.startsWith("/web/") ? "classpath:" + path : path));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSessionId() {
        HttpSession session = RequestUtil.getSession((ServletRequest)RequestUtil.getRequest());
        return session == null ? null : session.getId();
    }

    public static HttpServletRequest assertRequest() {
        HttpServletRequest request = RequestUtil.getRequest();
        Assert.state((request != null ? 1 : 0) != 0, (String)"Method must be invoked within the scope of a servlet request.");
        return request;
    }

    private static boolean isEmpty(String s) {
        return StringUtils.isEmpty((String)s) || "unknown".equalsIgnoreCase(s);
    }

    private RequestUtil() {
    }
}

