/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.reflect.FieldUtils;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.OnFailure;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.event.Event;
import org.fujion.event.IEventListener;

public class EventHandlerScanner {
    public static void wire(Object instance, BaseComponent root) {
        for (Class<?> clazz = instance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            EventHandlerScanner.wire(instance, root, clazz);
        }
    }

    private static void wire(Object instance, BaseComponent root, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            EventHandler[] annotations;
            method.setAccessible(true);
            for (EventHandler annot : annotations = (EventHandler[])method.getAnnotationsByType(EventHandler.class)) {
                OnFailure onFailure = annot.onFailure();
                Class<?>[] params = method.getParameterTypes();
                if (params.length > 1 || params.length == 1 && !Event.class.isAssignableFrom(params[0])) {
                    onFailure.doAction("Method " + method.getName() + " signature does not conform to that of an event handler.", new Object[0]);
                    return;
                }
                Set<String> targets = EventHandlerScanner.asSet(annot.target());
                Set<String> types = EventHandlerScanner.asSet(annot.value());
                BaseComponent component = null;
                if (types.isEmpty()) {
                    onFailure.doAction("At least one event type must be specified", new Object[0]);
                }
                if (targets.isEmpty()) {
                    targets.add("self");
                }
                for (String target : targets) {
                    if ("self".equals(target)) {
                        component = EventHandlerScanner.isComponent(clazz) ? (BaseComponent)instance : root;
                    } else if (target.startsWith("@")) {
                        Field field = EventHandlerScanner.findField(clazz, target.substring(1));
                        if (field != null) {
                            try {
                                field.setAccessible(true);
                                component = (BaseComponent)field.get(instance);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        BaseComponent baseComponent = component = root == null ? null : root.findByName(target);
                    }
                    if (component == null) {
                        onFailure.doAction("No suitable event handler target found for \"" + target + "\"", new Object[0]);
                        continue;
                    }
                    for (String type : types) {
                        component.addEventListener(type, (IEventListener)new EventListener(instance, method), annot.syncToClient());
                    }
                }
            }
        }
    }

    private static Set<String> asSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        for (String value : values) {
            if (value.isEmpty()) continue;
            set.add(value);
        }
        return set;
    }

    private static boolean isComponent(Class<?> clazz) {
        return BaseComponent.class.isAssignableFrom(clazz);
    }

    private static Field findField(Class<?> clazz, String name) {
        try {
            Field result = FieldUtils.getField(clazz, (String)name, (boolean)true);
            return EventHandlerScanner.isComponent(result.getType()) ? result : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private EventHandlerScanner() {
    }

    private static class EventListener
    implements IEventListener {
        private final Object target;
        private final Method method;

        EventListener(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        @Override
        public void onEvent(Event event) {
            try {
                if (this.method.getParameterTypes().length == 0) {
                    this.method.invoke(this.target, new Object[0]);
                } else {
                    this.method.invoke(this.target, event);
                }
            }
            catch (Throwable e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EventListener)) {
                return false;
            }
            EventListener el = (EventListener)object;
            return this.target == el.target && this.method.equals(el.method);
        }

        public int hashCode() {
            return this.target.hashCode() ^ this.method.hashCode();
        }
    }
}

