/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.CssClasses;
import org.fujion.ancillary.CssStyles;
import org.fujion.ancillary.IDisable;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.Popup;
import org.fujion.event.KeyCode;

public abstract class BaseUIComponent
extends BaseComponent
implements IDisable {
    private final CssStyles styles = new CssStyles();
    private final CssClasses classes = new CssClasses();
    private String height;
    private String width;
    private String flex;
    private String hint;
    private String balloon;
    private boolean disabled;
    private boolean visible = true;
    private int tabindex;
    private String css;
    private String dragid;
    private String dropid;
    private Popup context;
    private Popup popup;
    private String keycapture;

    public void addMask() {
        this.addMask(null);
    }

    public void addMask(String label) {
        this.invoke("addMask", label);
    }

    public void addMask(String label, Popup popup) {
        this.invoke("addMask", label, popup);
    }

    public void removeMask() {
        this.invoke("removeMask", new Object[0]);
    }

    @Component.PropertyGetter(value="style")
    public String getStyles() {
        return this.styles.toString();
    }

    @Component.PropertySetter(value="style")
    public void setStyles(String styles) {
        this.styles.parse(styles, true);
        this._syncStyles();
    }

    private String _syncStyle(String name, String dflt) {
        String current = this.styles.get(name);
        if (current != null) {
            return current;
        }
        this.styles.put(name, dflt);
        return dflt;
    }

    protected void _syncStyles() {
        this.height = this._syncStyle("height", this.height);
        this.width = this._syncStyle("width", this.width);
        this.flex = this._syncStyle("flex", this.flex);
        this.sync("style", this.styles.toString());
    }

    public String getStyle(String name) {
        return this.styles.get(name);
    }

    public String addStyle(String name, String value) {
        String oldValue = this.styles.put(name, value);
        this._syncStyles();
        return oldValue;
    }

    public void addStyles(String style) {
        this.styles.parse(style, false);
        this._syncStyles();
    }

    public String removeStyle(String name) {
        return this.addStyle(name, null);
    }

    @Component.PropertyGetter(value="class")
    public String getClasses() {
        return this.classes.toString();
    }

    public void setClasses(String value) {
        this.classes.parse(value);
        this._syncClasses();
    }

    protected void _syncClasses() {
        this.sync("clazz", this.classes.toString(true));
    }

    @Component.PropertySetter(value="class")
    public void addClass(String value) {
        if (this.classes.add(value)) {
            this._syncClasses();
        }
    }

    public void removeClass(String value) {
        if (this.classes.remove(value)) {
            this._syncClasses();
        }
    }

    public void toggleClass(String yesValue, String noValue, boolean condition) {
        if (this.classes.toggle(yesValue, noValue, condition)) {
            this._syncClasses();
        }
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    @Component.PropertyGetter(value="height")
    public String getHeight() {
        return this.height;
    }

    @Component.PropertySetter(value="height")
    public void setHeight(String height) {
        if (!this.areEqual(height = this.trimify(height), this.height)) {
            this.height = height;
            this.addStyle("height", height);
        }
    }

    @Component.PropertyGetter(value="width")
    public String getWidth() {
        return this.width;
    }

    @Component.PropertySetter(value="width")
    public void setWidth(String width) {
        if (!this.areEqual(width = this.trimify(width), this.width)) {
            this.width = width;
            this.addStyle("width", width);
        }
    }

    @Component.PropertyGetter(value="flex")
    public String getFlex() {
        return this.flex;
    }

    @Component.PropertySetter(value="flex")
    public void setFlex(String flex) {
        if (!this.areEqual(flex = this.trimify(flex), this.flex)) {
            this.flex = flex;
            this.addStyle("flex", flex);
        }
    }

    @Component.PropertySetter(value="focus", defer=true)
    public void setFocus(boolean focus) {
        this.invoke("focus", focus);
    }

    public void focus() {
        this.setFocus(true);
    }

    @Component.PropertyGetter(value="css")
    public String getCss() {
        return this.css;
    }

    @Component.PropertySetter(value="css")
    public void setCss(String css) {
        if (!this.areEqual(css = this.nullify(css), this.css)) {
            this.css = css;
            this.sync("css", this.css);
        }
    }

    @Component.PropertyGetter(value="hint")
    public String getHint() {
        return this.hint;
    }

    @Component.PropertySetter(value="hint")
    public void setHint(String hint) {
        if (!this.areEqual(hint = this.nullify(hint), this.hint)) {
            this.hint = hint;
            this.sync("hint", this.hint);
        }
    }

    @Component.PropertyGetter(value="balloon")
    public String getBalloon() {
        return this.balloon;
    }

    @Component.PropertySetter(value="balloon")
    public void setBalloon(String balloon) {
        if (!this.areEqual(balloon, this.balloon)) {
            this.balloon = balloon;
            this.sync("balloon", this.balloon);
        }
    }

    @Override
    @Component.PropertyGetter(value="disabled")
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Component.PropertySetter(value="disabled")
    public void setDisabled(boolean disabled) {
        if (disabled != this.disabled) {
            this.disabled = disabled;
            this.sync("disabled", this.disabled);
        }
    }

    @Component.PropertyGetter(value="visible")
    public boolean isVisible() {
        return this.visible;
    }

    @Component.PropertySetter(value="visible")
    public void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            this.sync("visible", this.visible);
        }
    }

    @Component.PropertyGetter(value="tabindex")
    public int getTabindex() {
        return this.tabindex;
    }

    @Component.PropertySetter(value="tabindex")
    public void setTabindex(int tabindex) {
        int n = tabindex = tabindex < 0 ? 0 : tabindex;
        if (tabindex != this.tabindex) {
            this.tabindex = tabindex;
            this.sync("tabindex", this.tabindex);
        }
    }

    @Component.PropertyGetter(value="dragid")
    public String getDragid() {
        return this.dragid;
    }

    @Component.PropertySetter(value="dragid")
    public void setDragid(String dragid) {
        if (!this.areEqual(dragid = this.trimify(dragid), this.dragid)) {
            this.dragid = dragid;
            this.sync("dragid", this.dragid);
        }
    }

    @Component.PropertyGetter(value="dropid")
    public String getDropid() {
        return this.dropid;
    }

    @Component.PropertySetter(value="dropid")
    public void setDropid(String dropid) {
        if (!this.areEqual(dropid = this.trimify(dropid), this.dropid)) {
            this.dropid = dropid;
            this.sync("dropid", this.dropid);
        }
    }

    @Component.PropertyGetter(value="context")
    public Popup getContext() {
        if (this.context != null && this.context.isDead()) {
            this.context = null;
            this.sync("context", this.context);
        }
        return this.context;
    }

    @Component.PropertySetter(value="context", defer=true)
    private void setContext(String context) {
        this.setContext(ConvertUtil.convert(context, Popup.class, this));
    }

    public void setContext(Popup context) {
        if (context != this.getContext()) {
            BaseUIComponent.validate(context);
            this.context = context;
            this.sync("context", this.context);
        }
    }

    @Component.PropertyGetter(value="popup")
    public Popup getPopup() {
        if (this.popup != null && this.popup.isDead()) {
            this.popup = null;
            this.sync("popup", this.popup);
        }
        return this.popup;
    }

    @Component.PropertySetter(value="popup", defer=true)
    public void setPopup(Popup popup) {
        if (popup != this.getPopup()) {
            BaseUIComponent.validate(popup);
            this.popup = popup;
            this.sync("popup", this.popup);
        }
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        super.afterRemoveChild(child);
        if (child == this.popup) {
            this.setPopup(null);
        }
    }

    @Component.PropertyGetter(value="keycapture")
    public String getKeycapture() {
        return this.keycapture;
    }

    @Component.PropertySetter(value="keycapture")
    public void setKeycapture(String keycapture) {
        if (!this.areEqual(keycapture = this.nullify(keycapture), this.keycapture)) {
            this.sync("keycapture", KeyCode.normalizeKeyCapture(keycapture));
            this.keycapture = keycapture;
        }
    }

    public void scrollIntoView(boolean alignToTop) {
        this.invoke("scrollIntoView", alignToTop);
    }

    public BaseUIComponent getFirstVisibleChild(boolean recurse) {
        return this.getFirstVisibleChild(BaseUIComponent.class, recurse);
    }

    public <T extends BaseUIComponent> T getFirstVisibleChild(Class<T> clazz, boolean recurse) {
        for (BaseUIComponent child : this.getChildren(clazz)) {
            if (!child.isVisible()) continue;
            return (T)child;
        }
        if (recurse) {
            for (BaseUIComponent child : this.getChildren(clazz)) {
                T comp = child.getFirstVisibleChild(clazz, recurse);
                if (comp == null) continue;
                return comp;
            }
        }
        return null;
    }
}

