/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Comparator;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.component.BaseLabeledImageComponent;
import org.fujion.component.Columns;
import org.fujion.component.Grid;
import org.fujion.component.Rows;
import org.fujion.model.IListModel;
import org.fujion.model.SmartComparator;
import org.fujion.model.Sorting;

@Component(tag="column", widgetClass="Column", widgetModule="fujion-grid", parentTag={"columns"}, childTag={@Component.ChildTag(value="*")})
public class Column
extends BaseLabeledImageComponent<BaseLabeledComponent.LabelPositionNone> {
    private Comparator<?> sortComparator;
    private Sorting.SortOrder sortOrder = Sorting.SortOrder.UNSORTED;
    private Sorting.SortToggle sortToggle;
    private boolean sortColumn;

    public Column() {
    }

    public Column(String label) {
        super(label);
    }

    public Comparator<?> getSortComparator() {
        return this.sortComparator;
    }

    public void setSortComparator(Comparator<?> sortComparator) {
        if (sortComparator != this.sortComparator) {
            this.sortComparator = sortComparator;
            this.sortOrder = Sorting.SortOrder.UNSORTED;
            this.updateClient();
        }
    }

    @Component.PropertySetter(value="sortBy")
    public void setSortComparator(String propertyName) {
        this.setSortComparator(new SmartComparator(propertyName));
    }

    @Component.PropertyGetter(value="sortOrder")
    public Sorting.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Component.PropertySetter(value="sortOrder")
    public void setSortOrder(Sorting.SortOrder sortOrder) {
        this.sortOrder = sortOrder == null ? Sorting.SortOrder.UNSORTED : sortOrder;
    }

    @Component.PropertyGetter(value="sortToggle")
    public Sorting.SortToggle getSortToggle() {
        return this.sortToggle;
    }

    @Component.PropertySetter(value="sortToggle")
    public void setSortToggle(Sorting.SortToggle sortToggle) {
        this.sortToggle = sortToggle;
    }

    public void toggleSort() {
        int i = this.sortOrder.ordinal() + 1;
        int max = this.sortToggle == Sorting.SortToggle.TRISTATE ? 3 : 2;
        this.setSortOrder(Sorting.SortOrder.values()[i >= max ? 0 : i]);
        this.sort();
    }

    public void sort() {
        if (!this.sortColumn) {
            this.setSortColumn(true);
            return;
        }
        IListModel<Object> model = this.sortComparator == null || this.sortOrder == Sorting.SortOrder.UNSORTED ? null : this.getModel();
        this.updateClient();
        if (model != null) {
            Comparator<?> comparator = this.sortOrder == Sorting.SortOrder.NATIVE ? null : this.sortComparator;
            model.sort(comparator, this.sortOrder != Sorting.SortOrder.DESCENDING);
        }
    }

    private IListModel<Object> getModel() {
        Grid grid = this.getAncestor(Grid.class);
        Rows rows = grid == null ? null : grid.getRows();
        return rows == null ? null : rows.getModelAndView(Object.class).getModel();
    }

    @EventHandler(value={"sort"}, syncToClient=false)
    private void _sort() {
        this.toggleSort();
    }

    @Component.PropertyGetter(value="sortColumn")
    public boolean isSortColumn() {
        return this.sortColumn;
    }

    @Component.PropertySetter(value="sortColumn")
    public void setSortColumn(boolean sortColumn) {
        this._setSortColumn(sortColumn, true);
    }

    protected void _setSortColumn(boolean sortColumn, boolean notifyParent) {
        if (sortColumn != this.sortColumn) {
            Columns parent;
            this.sortColumn = sortColumn;
            if (sortColumn) {
                this.sort();
            } else {
                this.updateClient();
            }
            if (notifyParent && (parent = (Columns)this.getParent()) != null) {
                if (sortColumn) {
                    parent.setSortColumn(this);
                } else if (parent.getSortColumn() == this) {
                    parent.setSortColumn(null);
                }
            }
        }
    }

    private void updateClient() {
        this.sync("sortOrder", (Object)(this.sortComparator == null ? null : (this.sortColumn ? this.sortOrder : Sorting.SortOrder.UNSORTED)));
    }
}

