/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.fujion.event.Event;
import org.fujion.event.IEventListener;

public class EventListeners {
    private final Map<String, Set<IEventListener>> allListeners = new HashMap<String, Set<IEventListener>>();

    public void add(String eventType, IEventListener eventListener) {
        this.getListeners(eventType, true).add(eventListener);
    }

    public void remove(String eventType, IEventListener eventListener) {
        Set<IEventListener> listeners = this.getListeners(eventType, false);
        if (listeners != null) {
            listeners.remove(eventListener);
            if (listeners.isEmpty()) {
                this.allListeners.remove(eventType);
            }
        }
    }

    public void removeAll() {
        this.allListeners.clear();
    }

    public void removeAll(String eventType) {
        this.allListeners.remove(eventType);
    }

    public void invoke(Event event) {
        Set<IEventListener> listeners = this.getListeners(event.getType(), false);
        if (listeners != null) {
            for (IEventListener listener : new ArrayList<IEventListener>(listeners)) {
                if (event.isStopped()) break;
                listener.onEvent(event);
            }
        }
    }

    public boolean hasListeners(String eventType) {
        Set<IEventListener> listeners = this.getListeners(eventType, false);
        return listeners != null && !listeners.isEmpty();
    }

    private Set<IEventListener> getListeners(String eventType, boolean forceCreate) {
        Set<IEventListener> listeners = this.allListeners.get(eventType);
        if (listeners == null && forceCreate) {
            listeners = new LinkedHashSet<IEventListener>();
            this.allListeners.put(eventType, listeners);
        }
        return listeners;
    }
}

