/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fujion.ancillary.ComponentException;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.expression.ELContext;
import org.fujion.expression.ELEvaluator;
import org.fujion.page.PageElement;

public class PageDefinition {
    private final PageElement root = new PageElement(null, null);
    private String source;

    public PageElement getRootElement() {
        return this.root;
    }

    public String getSource() {
        return this.source;
    }

    void setSource(String source) {
        this.source = source;
    }

    public List<BaseComponent> materialize(BaseComponent parent) {
        return this.materialize(parent, null);
    }

    public List<BaseComponent> materialize(BaseComponent parent, Map<String, Object> args) {
        try {
            ArrayList<ComponentDefinition.DeferredSetter> deferrals = new ArrayList<ComponentDefinition.DeferredSetter>();
            ArrayList<BaseComponent> created = new ArrayList<BaseComponent>();
            this.materialize(this.root.getChildren(), parent, deferrals, args, created);
            for (ComponentDefinition.DeferredSetter deferral : deferrals) {
                deferral.execute();
            }
            return created;
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e, "Exception materializing page definition '%s'", this.source);
        }
    }

    private void materialize(Iterable<PageElement> children, BaseComponent parent, List<ComponentDefinition.DeferredSetter> deferrals, Map<String, Object> args, List<BaseComponent> created) {
        if (children != null) {
            for (PageElement child : children) {
                BaseComponent component = this.materialize(child, parent, deferrals, args);
                if (created == null) continue;
                if (args != null && !args.isEmpty()) {
                    component.getAttributes().putAll(args);
                }
                created.add(component);
            }
        }
    }

    private BaseComponent materialize(PageElement element, BaseComponent parent, List<ComponentDefinition.DeferredSetter> deferrals, Map<String, Object> args) {
        Map<String, String> attributes;
        BaseComponent component;
        boolean skip;
        ComponentDefinition def = element.getDefinition();
        boolean merge = parent instanceof Page && def.getComponentClass() == Page.class;
        boolean bl = skip = def.getComponentClass() == Page.class && parent != null;
        if (merge) {
            component = parent;
            parent = null;
            attributes = element.getAttributes();
        } else if (skip) {
            component = parent;
            parent = null;
            attributes = null;
        } else {
            attributes = element.getAttributes();
            component = def.getFactory().create(attributes);
            if (component == null) {
                return null;
            }
        }
        if (attributes != null) {
            ELContext elContext = new ELContext(component, parent, element, args);
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                Object value = ELEvaluator.getInstance().evaluate(attribute.getValue(), elContext);
                ComponentDefinition.DeferredSetter deferral = def.setProperty(component, attribute.getKey(), value);
                if (deferral == null) continue;
                deferrals.add(deferral);
            }
        }
        this.materialize(element.getChildren(), component, deferrals, args, null);
        if (parent != null) {
            parent.addChild(component);
        }
        return component;
    }
}

