/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.util.List;
import java.util.Map;
import org.fujion.client.ExecutionContext;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageDefinitionCache;
import org.fujion.page.PageParser;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class PageUtil {
    public static PageDefinition getPageDefinition(String url) {
        return PageDefinitionCache.getInstance().get(url);
    }

    public static List<BaseComponent> createPage(String url, BaseComponent parent) {
        return PageUtil.createPage(url, parent, null);
    }

    public static List<BaseComponent> createPage(String url, BaseComponent parent, Map<String, Object> args) {
        return PageUtil.createPage(PageUtil.getPageDefinition(url), parent, args);
    }

    public static List<BaseComponent> createPage(PageDefinition def, BaseComponent parent) {
        return PageUtil.createPage(def, parent, null);
    }

    public static List<BaseComponent> createPage(PageDefinition def, BaseComponent parent, Map<String, Object> args) {
        return def.materialize(parent, args);
    }

    public static List<BaseComponent> createPageFromContent(String content, BaseComponent parent) {
        return PageUtil.createPageFromContent(content, parent, null);
    }

    public static List<BaseComponent> createPageFromContent(String content, BaseComponent parent, Map<String, Object> args) {
        ByteArrayResource resource = new ByteArrayResource(content.getBytes());
        return PageUtil.createPage(PageParser.getInstance().parse((Resource)resource), parent, args);
    }

    public static boolean inExecutionContext(Page page) {
        return page != null && ExecutionContext.getPage() == page;
    }

    private PageUtil() {
    }
}

