/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.taglib;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.fujion.common.MiscUtil;
import org.fujion.common.XMLUtil;
import org.fujion.core.WebUtil;
import org.fujion.taglib.TagLibrary;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TagLibraryParser {
    private static final TagLibraryParser instance = new TagLibraryParser();

    public static TagLibraryParser getInstance() {
        return instance;
    }

    private TagLibraryParser() {
    }

    public TagLibrary parse(String src) {
        return this.parse(WebUtil.getResource(src));
    }

    public TagLibrary parse(Resource resource) {
        try {
            return this.parse(resource.getInputStream());
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public TagLibrary parse(InputStream stream) {
        try {
            Element root = XMLUtil.parseXMLFromStream((InputStream)stream).getDocumentElement();
            String uri = this.getValue(root, "uri");
            NodeList nodes = root.getElementsByTagName("function");
            int nodeCount = nodes.getLength();
            TagLibrary tagLibrary = new TagLibrary(uri);
            for (int i = 0; i < nodeCount; ++i) {
                Element ele = (Element)nodes.item(i);
                String name = this.getValue(ele, "name");
                String clazz = this.getValue(ele, "function-class");
                String signature = this.getValue(ele, "function-signature");
                tagLibrary.addFunction(name, clazz, signature);
            }
            TagLibrary tagLibrary2 = tagLibrary;
            return tagLibrary2;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private String getValue(Element ele, String tag) {
        NodeList nodes = ele.getElementsByTagName(tag);
        if (nodes.getLength() == 0) {
            throw new RuntimeException("Tag library definition missing attribute: " + tag);
        }
        return nodes.item(0).getTextContent().trim();
    }
}

